package cn.net.wanmo.plugin.wechat.officialaccount.util.message.event.req.menu;

import cn.net.wanmo.plugin.wechat.officialaccount.util.message.event.req.base.EventReqMessage;
import cn.net.wanmo.plugin.wechat.officialaccount.util.message.plain.ReqMessageUtil;

import java.util.Map;

/**
 * 点击菜单拉取消息时的事件推送<br/>
 * 弹出地理位置选择器的事件推送<br/>
 * 事件类型，location_select
 */
public class MenuLocationSelectMessage extends EventReqMessage {

    /**
     * 点击菜单跳转链接时的事件推送: 事件KEY值，与自定义菜单接口中KEY值对应 <br/>
     */
    private String eventKey;

    /**
     * 发送的位置信息
     */
    private SendLocationInfo sendLocationInfo = new SendLocationInfo();

    public MenuLocationSelectMessage() {
    }

    public MenuLocationSelectMessage(Map<String, String> requestMap) {
        super(requestMap);
        this.eventKey = requestMap.get("EventKey");
        {
            String infoXml = requestMap.getOrDefault("SendLocationInfo", "");
            Map<String, String> parseXml = ReqMessageUtil.parseXml2Map(infoXml);
            this.sendLocationInfo.locationX = parseXml.get("Location_X");
            this.sendLocationInfo.locationY = parseXml.get("Location_Y");
            this.sendLocationInfo.scale = parseXml.get("Scale");
            this.sendLocationInfo.label = parseXml.get("Label");
            this.sendLocationInfo.poiname = parseXml.get("Poiname");
        }
    }

    public String getEventKey() {
        return eventKey;
    }

    public void setEventKey(String eventKey) {
        this.eventKey = eventKey;
    }

    public SendLocationInfo getSendLocationInfo() {
        return sendLocationInfo;
    }

    public void setSendLocationInfo(SendLocationInfo sendLocationInfo) {
        this.sendLocationInfo = sendLocationInfo;
    }

    /**
     * 发送的位置信息
     */
    public class SendLocationInfo{

        /**
         * 发送的位置信息: X坐标信息
         */
        private String locationX;

        /**
         * 发送的位置信息: Y坐标信息
         */
        private String locationY;

        /**
         * 发送的位置信息: 精度，可理解为精度或者比例尺、越精细的话 scale越高
         */
        private String scale;

        /**
         * 发送的位置信息: 地理位置的字符串信息
         */
        private String label;

        /**
         * 发送的位置信息: 朋友圈POI的名字，可能为空
         */
        private String poiname;

        public SendLocationInfo() {
        }

        public String getLocationX() {
            return locationX;
        }

        public void setLocationX(String locationX) {
            this.locationX = locationX;
        }

        public String getLocationY() {
            return locationY;
        }

        public void setLocationY(String locationY) {
            this.locationY = locationY;
        }

        public String getScale() {
            return scale;
        }

        public void setScale(String scale) {
            this.scale = scale;
        }

        public String getLabel() {
            return label;
        }

        public void setLabel(String label) {
            this.label = label;
        }

        public String getPoiname() {
            return poiname;
        }

        public void setPoiname(String poiname) {
            this.poiname = poiname;
        }
    }
}
