package cn.net.wanmo.plugin.wechat.officialaccount.util.message.event.req.menu;

import cn.net.wanmo.plugin.wechat.officialaccount.util.message.event.req.base.EventReqMessage;

import java.util.Map;

/**
 * 点击菜单拉取消息时的事件推送<br/>
 * 用户点击自定义菜单后，微信会把点击事件推送给开发者，请注意，点击菜单弹出子菜单，不会产生上报。<br/>
 * 点击菜单跳转链接时的事件推送
 * 事件类型，VIEW
 */
public class MenuViewMessage extends EventReqMessage {

    /**
     * 点击菜单跳转链接时的事件推送: 事件KEY值，设置的跳转URL <br/>
     */
    private String eventKey;
    /**
     * 指菜单ID，如果是个性化菜单，则可以通过这个字段，知道是哪个规则的菜单被点击了。
     */
    private String menuID;

    public MenuViewMessage() {
    }

    public MenuViewMessage(Map<String, String> requestMap) {
        super(requestMap);
        this.eventKey = requestMap.get("EventKey");
        this.menuID = requestMap.get("MenuId");
    }

    public String getEventKey() {
        return eventKey;
    }

    public void setEventKey(String eventKey) {
        this.eventKey = eventKey;
    }

    public String getMenuID() {
        return menuID;
    }

    public void setMenuID(String menuID) {
        this.menuID = menuID;
    }
}
