package cn.net.wanmo.plugin.wechat.officialaccount.util.message.plain.req;

import cn.net.wanmo.common.util.StringUtil;

/**
 * 公众号请求消息类型
 */
public enum ReqMessageType {
    unknown("unknown", "未知类型"),
    text("text", "文本消息"),
    image("image", "图片消息"),
    voice("voice", "语音消息"),
    video("video", "视频消息"),
    shortvideo("shortvideo", "小视频消息"),
    location("location", "地理位置消息"),
    link("link", "链接消息"),
    event("event", "事件消息"),
    ;

    private final String value;
    private final String label;

    ReqMessageType(String value, String label) {
        this.value = value;
        this.label = label;
    }

    public String getValue() {
        return value;
    }

    public String getLabel() {
        return label;
    }

    public static ReqMessageType convertOf(String value) {
        ReqMessageType r = ReqMessageType.unknown;

        for (ReqMessageType type : values()) {
            if (StringUtil.equals(value, type.getValue())) {
                r = type;
                break;
            }
        }

        return r;
    }
}
