package cn.net.wanmo.plugin.wechat.officialaccount.util.message.plain.req.base;

import cn.net.wanmo.plugin.wechat.officialaccount.util.message.plain.req.ReqMessageType;
import com.alibaba.fastjson2.JSON;

import java.util.Map;

/**
 * 消息基类（普通用户 -> 公众帐号）
 */
public abstract class PlainReqMessage {

    /**
     * 获取请求消息类型
     * @param requestMap 请求数据
     * @return 消息类型
     */
    public static ReqMessageType getMsgType(Map<String, String> requestMap) {
        return ReqMessageType.convertOf(requestMap.get("MsgType"));
    }

    /**
     * 消息类型
     */
    protected ReqMessageType msgType;
    /**
     * 消息id，64位整型
     */
    protected String msgId;
    /**
     * 开发者微信号
     */
    protected String toUserName;
    /**
     * 发送方账号（一个OpenID）
     */
    protected String fromUserName;
    /**
     * 消息创建时间 （整型）
     */
    protected long createTime;
    /**
     * 消息的数据ID（消息如果来自文章时才有）
     */
    protected String msgDataId;
    /**
     * 多图文时第几篇文章，从1开始（消息如果来自文章时才有）
     */
    protected String idx;
    /**
     * todo 描述属性
     */
    protected String event;
    /**
     * todo 描述属性
     */
    protected String eventKey;
    /**
     * todo 描述属性
     */
    protected String ticket;

    /**
     * 响应的消息<br/>
     * 如果没有响应的 xml，则默认响应 "success"
     */
    protected String plainResXml = "success";

    public PlainReqMessage() {
        super();
    }

    public PlainReqMessage(Map<String, String> requestMap) {
        this();

        this.msgType = ReqMessageType.convertOf(requestMap.get("MsgType"));
        this.toUserName = requestMap.get("ToUserName");
        this.fromUserName = requestMap.get("FromUserName");
        this.msgId = requestMap.get("MsgId");
        this.createTime = Long.valueOf(requestMap.get("CreateTime"));
        this.msgDataId = requestMap.get("MsgDataId");
        this.idx = requestMap.get("Idx");
    }

    public ReqMessageType getMsgType() {
        return msgType;
    }

    public void setMsgType(ReqMessageType msgType) {
        this.msgType = msgType;
    }

    public String getToUserName() {
        return toUserName;
    }

    public void setToUserName(String toUserName) {
        this.toUserName = toUserName;
    }

    public String getFromUserName() {
        return fromUserName;
    }

    public void setFromUserName(String fromUserName) {
        this.fromUserName = fromUserName;
    }

    public long getCreateTime() {
        return createTime;
    }

    public void setCreateTime(long createTime) {
        this.createTime = createTime;
    }

    public String getMsgId() {
        return msgId;
    }

    public void setMsgId(String msgId) {
        this.msgId = msgId;
    }

    public String getEvent() {
        return event;
    }

    public void setEvent(String event) {
        this.event = event;
    }

    public String getEventKey() {
        return eventKey;
    }

    public void setEventKey(String eventKey) {
        this.eventKey = eventKey;
    }

    public String getTicket() {
        return ticket;
    }

    public void setTicket(String ticket) {
        this.ticket = ticket;
    }

    public String getMsgDataId() {
        return msgDataId;
    }

    public void setMsgDataId(String msgDataId) {
        this.msgDataId = msgDataId;
    }

    public String getIdx() {
        return idx;
    }

    public void setIdx(String idx) {
        this.idx = idx;
    }

    public String getPlainResXml() {
        return plainResXml;
    }

    public void setPlainResXml(String plainResXml) {
        this.plainResXml = plainResXml;
    }

    public String toJSONString() {
        return JSON.toJSONString(this);
    }
}
