package cn.net.wanmo.plugin.wechat.officialaccount.util.message.template;

import cn.net.wanmo.common.send.SendUtil;
import cn.net.wanmo.plugin.wechat.officialaccount.util.CommonUtil;
import cn.net.wanmo.plugin.wechat.officialaccount.util.message.template.pojo.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * 消息模板工具类
 */
public class TemplateUtil {
    private static Logger logger = LoggerFactory.getLogger(TemplateUtil.class);

    /**
     * 设置所属行业<br/>
     *
     * @param accessToken 访问令牌
     * @param req         请求体
     * @return 响应结果
     */
    public static ApiSetIndustryRes apiSetIndustry(String accessToken, ApiSetIndustryReq req) {
        String msgPre = CommonUtil.getInterfaceTitle("微信公众号 设置所属行业: ");

        String url = "https://api.weixin.qq.com/cgi-bin/template/api_set_industry?access_token=ACCESS_TOKEN";
        url = url.replace("ACCESS_TOKEN", accessToken);

        req.setBody(req.toBody());
        ApiSetIndustryRes res = new ApiSetIndustryRes();
        return SendUtil.post(msgPre, url, req, res,null);
    }


    /**
     * 获取账号设置的行业信息<br/>
     *
     * @param accessToken 访问令牌
     * @return 响应结果
     */
    public static GetIndustryRes getIndustry(String accessToken) {
        String msgPre = CommonUtil.getInterfaceTitle( "微信公众号 获取账号设置的行业信息: ");

        String url = "https://api.weixin.qq.com/cgi-bin/template/get_industry?access_token=ACCESS_TOKEN";
        url = url.replace("ACCESS_TOKEN", accessToken);

        GetIndustryReq req = GetIndustryReq.build();
        GetIndustryRes res = new GetIndustryRes();
        return SendUtil.get(msgPre, url, req, res, null);
    }


    /**
     * 获得模板ID<br/>
     *
     * @param accessToken 访问令牌
     * @param req         请求体
     * @return 响应结果
     */
    public static ApiAddPrivateTemplateRes apiAddTemplate(String accessToken, ApiAddPrivateTemplateReq req) {
        String msgPre = CommonUtil.getInterfaceTitle( "微信公众号 获得模板ID: ");

        String url = "https://api.weixin.qq.com/cgi-bin/template/api_add_template?access_token=ACCESS_TOKEN";
        url = url.replace("ACCESS_TOKEN", accessToken);

        req.setBody(req.toBody());
        ApiAddPrivateTemplateRes res = new ApiAddPrivateTemplateRes();
        return SendUtil.post(msgPre, url, req, res, null);
    }

    /**
     * 获取账号下所有模板信息<br/>
     *
     * @param accessToken 访问令牌
     * @return 响应结果
     */
    public static GetAllPrivateTemplateRes getAllPrivateTemplate(String accessToken) {
        String msgPre = CommonUtil.getInterfaceTitle("微信公众号 获取账号下所有模板信息: ");

        String url = "https://api.weixin.qq.com/cgi-bin/template/get_all_private_template?access_token=ACCESS_TOKEN";
        url = url.replace("ACCESS_TOKEN", accessToken);

        GetAllPrivateTemplateReq req = GetAllPrivateTemplateReq.build();
        GetAllPrivateTemplateRes res = new GetAllPrivateTemplateRes();
        return SendUtil.get(msgPre, url, req, res, null);
    }


    /**
     * 删除消息模板<br/>
     *
     * @param accessToken 访问令牌
     * @param req         请求体
     * @return 响应结果
     */
    public static DelPrivateTemplateRes delPrivateTemplate(String accessToken, DelPrivateTemplateReq req) {
        String msgPre = CommonUtil.getInterfaceTitle( "微信公众号 删除消息模板: ");

        String url = "https://api.weixin.qq.com/cgi-bin/template/del_private_template?access_token=ACCESS_TOKEN";
        url = url.replace("ACCESS_TOKEN", accessToken);

        req.setBody(req.toBody());
        DelPrivateTemplateRes res = new DelPrivateTemplateRes();
        return SendUtil.post(msgPre, url, req, res, null);
    }

    /**
     * 发送模板消息<br/>
     *
     * @param accessToken 访问令牌
     * @param req         请求体
     * @return 响应结果
     */
    public static SendPrivateTemplateRes sendPrivateTemplate( String accessToken, SendPrivateTemplateReq req) {
        String msgPre = CommonUtil.getInterfaceTitle( "微信公众号 发送模板消息: ");

        String url = "https://api.weixin.qq.com/cgi-bin/message/template/send?access_token=ACCESS_TOKEN";
        url = url.replace("ACCESS_TOKEN", accessToken);

        req.setBody(req.toBody());
        SendPrivateTemplateRes res = new SendPrivateTemplateRes();
        return SendUtil.post(msgPre, url, req, res, null);
    }

}
