package cn.net.wanmo.plugin.wechat.officialaccount.util.message.template.pojo;

import cn.net.wanmo.common.send.BaseReq;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;

import java.util.ArrayList;
import java.util.List;

public class ApiAddPrivateTemplateReq extends BaseReq {
    @Override
    public String toBody() {
        JSONObject req = new JSONObject();
        req.put("template_id_short", this.templateIdShort);

        {
            JSONArray array = new JSONArray();
            for (String s : keywordNameList) {
                array.add(s);
            }
            req.put("keyword_name_list", array);
        }

        return req.toJSONString();
    }

    // =================================================

    /**
     * 是	模板库中模板的编号，有“TM**”和“OPENTMTM**”等形式,对于类目模板，为纯数字ID
     */
    private String templateIdShort;
    /**
     * 是	选用的类目模板的关键词,按顺序传入,如果为空，或者关键词不在模板库中，会返回40246错误码
     */
    private List<String> keywordNameList = new ArrayList<>();

    public ApiAddPrivateTemplateReq() {
    }

    public String getTemplateIdShort() {
        return templateIdShort;
    }

    public void setTemplateIdShort(String templateIdShort) {
        this.templateIdShort = templateIdShort;
    }

    public List<String> getKeywordNameList() {
        return keywordNameList;
    }

    public void setKeywordNameList(List<String> keywordNameList) {
        this.keywordNameList = keywordNameList;
    }
}
