package cn.net.wanmo.plugin.wechat.officialaccount.util.message.template.pojo;

import cn.net.wanmo.plugin.wechat.officialaccount.pojo.WechatBaseRes;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;

import java.util.ArrayList;
import java.util.List;

public class GetAllPrivateTemplateRes extends WechatBaseRes<List<GetAllPrivateTemplateData>> {
    @Override
    public GetAllPrivateTemplateRes parseObj(String resBody) {
        JSONObject jsonObject = JSONObject.parseObject(resBody);

        this.data = new ArrayList<>();

        { // 消息模板列表
            JSONArray templateList = jsonObject.getJSONArray("template_list");
            for (Object o : templateList) {
                JSONObject temp = JSONObject.from(o);

                {
                    GetAllPrivateTemplateData templateObj = new GetAllPrivateTemplateData();
                    templateObj.setTemplateId(temp.getString("template_id"));
                    templateObj.setTitle(temp.getString("title"));
                    templateObj.setPrimaryIndustry(temp.getString("primary_industry"));
                    templateObj.setDeputyIndustry(temp.getString("deputy_industry"));
                    templateObj.setContent(temp.getString("content"));
                    templateObj.setExample(temp.getString("example"));


                    this.data.add(templateObj);
                }
            }
        }

        return this;
    }

}
