package cn.net.wanmo.plugin.wechat.officialaccount.util.oauth2;

import cn.net.wanmo.common.codec.CodecUtil;
import cn.net.wanmo.common.send.SendUtil;
import cn.net.wanmo.plugin.wechat.officialaccount.util.CommonUtil;
import cn.net.wanmo.plugin.wechat.officialaccount.util.oauth2.pojo.Oauth2AccessTokenReq;
import cn.net.wanmo.plugin.wechat.officialaccount.util.oauth2.pojo.Oauth2AccessTokenRes;
import cn.net.wanmo.plugin.wechat.officialaccount.util.oauth2.pojo.Oauth2RefreshTokenReq;
import cn.net.wanmo.plugin.wechat.officialaccount.util.oauth2.pojo.Oauth2RefreshTokenRes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * 网页开发 网页授权
 */
public class Oauth2Util {
    private static Logger logger = LoggerFactory.getLogger(Oauth2Util.class);


    /**
     * 第一步：用户同意授权，获取code <br/>
     * 在确保微信公众账号拥有授权作用域（scope参数）的权限的前提下（已认证服务号，默认拥有scope参数中的snsapi_base和snsapi_userinfo 权限），引导关注者打开如下页面
     *
     * @param appid       是 公众号APPID
     * @param redirectUri 是 待跳转的 url
     * @param scope       是 应用授权作用域，snsapi_base （不弹出授权页面，直接跳转，只能获取用户openid），snsapi_userinfo （弹出授权页面，可通过openid拿到昵称、性别、所在地。并且， 即使在未关注的情况下，只要用户授权，也能获取其信息 ）
     * @param state       否 重定向后会带上state参数，开发者可以填写a-zA-Z0-9的参数值，最多128字节
     * @return url
     */
    public static String createOauth2Url(String appid, String redirectUri, String scope, String state) {
        String url = "https://open.weixin.qq.com/connect/oauth2/authorize?appid=APPID&redirect_uri=REDIRECT_URI&response_type=code&scope=SCOPE&state=STATE#wechat_redirect";
        url = url.replace("APPID", appid);
        url = url.replace("REDIRECT_URI", CodecUtil.urlEncode(redirectUri));
        url = url.replace("SCOPE", scope);
        url = url.replace("STATE", state);

        return url;
    }


    /**
     * 获取网页授权 access_token <br/>
     *
     * @param appId       公众号ID
     * @param appSecret   公众号密钥
     * @param code        网页授权code
     * @return 响应结果
     */
    public static Oauth2AccessTokenRes getAccessToken( String appId, String appSecret, String code) {
        String msgPre = CommonUtil.getInterfaceTitle( "微信公众号 通过code换取网页授权access_token: ");

        String url = "https://api.weixin.qq.com/sns/oauth2/access_token?appid=APPID&secret=SECRET&code=CODE&grant_type=authorization_code";
        url = url.replace("APPID", appId);
        url = url.replace("SECRET", appSecret);
        url = url.replace("CODE", code);

        Oauth2AccessTokenReq req = new Oauth2AccessTokenReq();
        Oauth2AccessTokenRes res = new Oauth2AccessTokenRes();
        return SendUtil.get(msgPre, url, req, res, null);
    }

    /**
     * 刷新网页授权 access_token <br/>
     *
     * @param appId        公众号ID
     * @param refreshToken 用户刷新access_token
     * @return 响应结果
     */
    public static Oauth2RefreshTokenRes getRefreshToken(String appId, String refreshToken) {
        String msgPre = CommonUtil.getInterfaceTitle("微信公众号 刷新网页授权access_token: ");

        String url = "https://api.weixin.qq.com/sns/oauth2/refresh_token?appid=APPID&grant_type=refresh_token&refresh_token=REFRESH_TOKEN";
        url = url.replace("APPID", appId);
        url = url.replace("REFRESH_TOKEN", refreshToken);

        Oauth2RefreshTokenReq req = new Oauth2RefreshTokenReq();
        Oauth2RefreshTokenRes res = new Oauth2RefreshTokenRes();
        return SendUtil.get(msgPre, url, req, res, null);
    }


    /**
     * 拉取用户信息(需scope为 snsapi_userinfo)
     */
    public static void getSnsapiUserinfo() {
        // todo 拉取用户信息(需scope为 snsapi_userinfo)
        String url = "https://api.weixin.qq.com/sns/userinfo?access_token=ACCESS_TOKEN&openid=OPENID&lang=zh_CN";
    }

    /**
     * 检验授权凭证（access_token）是否有效
     */
    public static void validAccessToken() {
        String url = "https://api.weixin.qq.com/sns/auth?access_token=ACCESS_TOKEN&openid=OPENID";

    }
}
