package cn.net.wanmo.plugin.wechat.officialaccount.util.oauth2.pojo;

import cn.net.wanmo.plugin.wechat.officialaccount.pojo.WechatBaseRes;
import com.alibaba.fastjson2.JSONObject;

public class Oauth2AccessTokenRes extends WechatBaseRes<Oauth2AccessTokenData> {
    @Override
    public Oauth2AccessTokenRes parseObj(String resBody) {
        JSONObject object = JSONObject.parseObject(resBody);

        this.data = new Oauth2AccessTokenData();
        this.data.setAccessToken(object.getString("access_token"));
        this.data.setExpiresIn(object.getInteger("expires_in"));
        this.data.setRefreshToken(object.getString("refresh_token"));
        this.data.setOpenId(object.getString("openid"));
        this.data.setScope(object.getString("scope"));
        this.data.setIsSnapshotUser(object.getInteger("is_snapshotuser"));
        this.data.setUnionId(object.getString("unionid"));

        return this;
    }

}
