package cn.net.wanmo.plugin.wechat.officialaccount.util.qrcode;

import cn.net.wanmo.common.codec.CodecUtil;
import cn.net.wanmo.common.send.SendUtil;
import cn.net.wanmo.plugin.wechat.officialaccount.util.CommonUtil;
import cn.net.wanmo.plugin.wechat.officialaccount.util.qrcode.pojo.QrcodeCreateReq;
import cn.net.wanmo.plugin.wechat.officialaccount.util.qrcode.pojo.QrcodeCreateRes;
import cn.net.wanmo.plugin.wechat.officialaccount.util.qrcode.pojo.ShowQrcodeReq;
import cn.net.wanmo.plugin.wechat.officialaccount.util.qrcode.pojo.ShowQrcodeRes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * 账号管理 /生成带参数的二维码 <br/><br/>
 * 1、临时二维码，是有过期时间的，最长可以设置为在二维码生成后的30天（即2592000秒）后过期，但能够生成较多数量。临时二维码主要用于账号绑定等不要求二维码永久保存的业务场景<br/><br/>
 * 2、永久二维码，是无过期时间的，但数量较少（目前为最多10万个）。永久二维码主要用于适用于账号绑定、用户来源统计等场景<br/><br/>
 */
public class QrcodeUtil {
    private static Logger logger = LoggerFactory.getLogger(QrcodeUtil.class);


    /**
     * 生成带参数的二维码<br/>
     *
     * @param accessToken 访问令牌
     * @param req         请求体
     * @return 响应结果
     */
    public static QrcodeCreateRes createTicket( String accessToken, QrcodeCreateReq req) {
        String msgPre = CommonUtil.getInterfaceTitle( "微信公众号 生成带参数的二维码: ");

        String url = "https://api.weixin.qq.com/cgi-bin/qrcode/create?access_token=ACCESS_TOKEN";
        url = url.replace("ACCESS_TOKEN", accessToken);

        req.setBody(req.toBody());
        QrcodeCreateRes res = new QrcodeCreateRes();
        return SendUtil.post(msgPre, url, req, res, null);
    }

    /**
     * 用ticket换取二维码图片<br/>
     *
     * @param ticket 二维码ticket
     * @return 响应结果
     */
    public static ShowQrcodeRes showQrcode(String ticket) {
        String msgPre = CommonUtil.getInterfaceTitle("微信公众号 用ticket换取二维码图片: ");

        String url = "https://mp.weixin.qq.com/cgi-bin/showqrcode?ticket=TICKET";
        url = url.replace("TICKET", CodecUtil.urlEncode(ticket));

        ShowQrcodeReq req = new ShowQrcodeReq();
        ShowQrcodeRes res = new ShowQrcodeRes();

        return SendUtil.getFile(msgPre, url, req, res, null);
    }

}
