package cn.net.wanmo.plugin.wechat.officialaccount.util.shorten;

import cn.net.wanmo.common.send.SendUtil;
import cn.net.wanmo.plugin.wechat.officialaccount.util.CommonUtil;
import cn.net.wanmo.plugin.wechat.officialaccount.util.shorten.pojo.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;


public class ShortenUtil {
    private static Logger logger = LoggerFactory.getLogger(ShortenUtil.class);

    /**
     * 账号管理 /将不超过4KB的长信息转成短key<br/>
     *
     * @param accessToken 访问令牌
     * @return 响应结果
     */
    public static GenShortenRes genShorten( String accessToken, GenShortenReq req) {
        String title = CommonUtil.getInterfaceTitle( "微信公众号 将不超过4KB的长信息转成短key: ");

        String url = "https://api.weixin.qq.com/cgi-bin/shorten/gen?access_token=ACCESS_TOKEN";
        url = url.replace("ACCESS_TOKEN", accessToken);

        req.setBody(req.toBody());
        GenShortenRes res = new GenShortenRes();
        return SendUtil.post(title, url, req, res, null);
    }


    /**
     * 账号管理 /将短key还原为长信息<br/>
     *
     * @param accessToken 访问令牌
     * @return 响应结果
     */
    public static FetchShortenRes fetchShorten(String accessToken, FetchShortenReq req) {
        String title = CommonUtil.getInterfaceTitle( "微信公众号 将短key还原为长信息: ");

        String url = "https://api.weixin.qq.com/cgi-bin/shorten/fetch?access_token=ACCESS_TOKEN";
        url = url.replace("ACCESS_TOKEN", accessToken);

        req.setBody(req.toBody());
        FetchShortenRes res = new FetchShortenRes();
        return SendUtil.post(title, url, req, res, null);
    }
}
