package cn.net.wanmo.plugin.wechat.officialaccount.util.user;

import cn.net.wanmo.common.send.SendUtil;
import cn.net.wanmo.plugin.wechat.officialaccount.util.CommonUtil;
import cn.net.wanmo.plugin.wechat.officialaccount.util.user.pojo.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;


public class UserUtil {
    private static Logger logger = LoggerFactory.getLogger(UserUtil.class);


    /**
     * 用户管理 /获取用户基本信息(UnionID机制)<br/>
     *
     * @param accessToken 访问令牌
     * @return 响应结果
     */
    public static GetUserInfoByOpenidRes getUserInfoByOpenid( String accessToken, String openid) {
        String msgPre = CommonUtil.getInterfaceTitle( "微信公众号 通过openid获取用户基本信息: ");

        String url = "https://api.weixin.qq.com/cgi-bin/user/info?access_token=ACCESS_TOKEN&openid=OPENID&lang=zh_CN";
        url = url.replace("ACCESS_TOKEN", accessToken);
        url = url.replace("OPENID", openid);

        GetUserInfoByOpenidReq req = new GetUserInfoByOpenidReq();
        GetUserInfoByOpenidRes res = new GetUserInfoByOpenidRes();
        return SendUtil.get(msgPre, url, req, res, null);
    }

    /**
     * 用户管理 /批量获取用户基本信息(UnionID机制)<br/>
     *
     * @param accessToken 访问令牌
     * @return 响应结果
     */
    public static BatchGetUserInfoByOpenidRes batchGetUserInfoByOpenid(String accessToken, BatchGetUserInfoByOpenidReq req) {
        String msgPre = CommonUtil.getInterfaceTitle( "微信公众号 批量通过openid获取用户基本信息: ");

        String url = "https://api.weixin.qq.com/cgi-bin/user/info/batchget?access_token=ACCESS_TOKEN";
        url = url.replace("ACCESS_TOKEN", accessToken);

        req.setBody(req.toBody());
        BatchGetUserInfoByOpenidRes res = new BatchGetUserInfoByOpenidRes();
        return SendUtil.post(msgPre, url, req, res, null);
    }


}
