package cn.net.wanmo.plugin.wechat.officialaccount.util.user.pojo;

import cn.net.wanmo.common.send.BaseReq;
import cn.net.wanmo.common.util.CollectionUtil;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;

import java.util.ArrayList;
import java.util.List;

public class BatchGetUserInfoByOpenidReq extends BaseReq {

    public static BatchGetUserInfoByOpenidReq build(List<String> openIds) {
        BatchGetUserInfoByOpenidReq req = new BatchGetUserInfoByOpenidReq();

        if (CollectionUtil.isEmpty(openIds)) {
            return req;
        }

        for (String openid : openIds) {
            req.getUserList().add(req.newUser(openid));
        }


        return req;
    }

    @Override
    public String toBody() {
        JSONObject object = new JSONObject();

        {
            JSONArray array = new JSONArray();

            for (User user : this.userList) {
                JSONObject tmp = new JSONObject();
                tmp.put("openid", user.getOpenid());
                tmp.put("lang", user.getLang());

                array.add(tmp);
            }

            object.put("user_list", array);
        }

        return object.toJSONString();
    }

    // =======================================================

    private List<User> userList = new ArrayList<>();

    public BatchGetUserInfoByOpenidReq() {
    }

    public List<User> getUserList() {
        return userList;
    }

    public void setUserList(List<User> userList) {
        this.userList = userList;
    }

    public User newUser(String openid) {
        return new User(openid);
    }

    public class User {
        /**
         * 是	用户的标识，对当前公众号唯一
         */
        private String openid;
        /**
         * 否	国家地区语言版本，zh_CN 简体，zh_TW 繁体，en 英语，默认为zh-CN
         */
        private String lang = "zh_CN";

        public User() {
        }

        public User(String openid) {
            this.openid = openid;
        }

        public String getOpenid() {
            return openid;
        }

        public void setOpenid(String openid) {
            this.openid = openid;
        }

        public String getLang() {
            return lang;
        }

        public void setLang(String lang) {
            this.lang = lang;
        }
    }
}
