package cn.net.wanmo.plugin.wechat.officialaccount.util.user.pojo;

import cn.net.wanmo.common.send.BaseRes;
import cn.net.wanmo.plugin.wechat.officialaccount.pojo.WechatBaseRes;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;

import java.util.ArrayList;
import java.util.List;

public class BatchGetUserInfoByOpenidRes extends WechatBaseRes<List<UserInfo>> {
    @Override
    public BaseRes parseObj(String resBody) {
        JSONObject object = JSONObject.parseObject(resBody);

        this.data = new ArrayList<>();
        JSONArray userInfoList = object.getJSONArray("user_info_list");
        for (Object o : userInfoList) {
            JSONObject temp = JSONObject.from(o);
            UserInfo userInfo = new UserInfo();
            {
                userInfo.setSubscribe(temp.getString("subscribe"));
                userInfo.setOpenId(temp.getString("openid"));
                userInfo.setLanguage(temp.getString("language"));
                userInfo.setSubscribeTime(temp.getString("subscribe_time"));
                userInfo.setUnionId(temp.getString("unionid"));
                userInfo.setRemark(temp.getString("remark"));
                userInfo.setGroupId(temp.getString("groupid"));
                userInfo.setTagIdList(temp.getString("tagid_list"));
                userInfo.setSubscribeScene(temp.getString("subscribe_scene"));
                userInfo.setQrScene(temp.getString("qr_scene"));
                userInfo.setQrSceneStr(temp.getString("qr_scene_str"));
            }

            this.data.add(userInfo);
        }


        return super.parseObj(resBody);
    }
}
