package cn.net.wanmo.common.weixin.work.inner.client_api.util.jsapi_ticket;

import cn.net.wanmo.common.pojo.InterfaceResult;
import cn.net.wanmo.common.restful.SendUtil;
import cn.net.wanmo.common.weixin.work.inner.client_api.pojo.jsapi_ticket.JsapiTicketReqForAgentConfig;
import cn.net.wanmo.common.weixin.work.inner.client_api.pojo.jsapi_ticket.JsapiTicketReqForAgent;
import cn.net.wanmo.common.weixin.work.inner.client_api.pojo.jsapi_ticket.JsapiTicketResForAgentConfig;
import cn.net.wanmo.common.weixin.work.inner.client_api.pojo.jsapi_ticket.JsapiTicketResForAgent;
import cn.net.wanmo.common.weixin.work.inner.pojo.Agent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsapiTicketUtil {
    private static Logger logger = LoggerFactory.getLogger(JsapiTicketUtil.class);

    /**
     * 获取企业的jsapi_ticket。 <br/>
     *
     * @param agent 应用配置
     * @param req         请求体
     * @return 响应结果
     */
    public static InterfaceResult<JsapiTicketResForAgent> getJsapiTicketForAgent(Agent agent, JsapiTicketReqForAgent req) {
        String logPrevDesc = agent.getLogPrevDesc();
        String token = agent.takeToken();

        return getJsapiTicketForAgent(logPrevDesc, token, req);
    }


    /**
     * 获取企业的jsapi_ticket。 <br/>
     *
     * @param logPrevDesc 日志前缀描述
     * @param token       应用令牌
     * @param req         请求体
     * @return 响应结果
     */
    public static InterfaceResult<JsapiTicketResForAgent> getJsapiTicketForAgent(String logPrevDesc, String token, JsapiTicketReqForAgent req) {
        String msgPre = logPrevDesc + ":" + "获取企业的jsapi_ticket: ";

        req.setBody(null);
        JsapiTicketResForAgent res = new JsapiTicketResForAgent();

        String url = "https://qyapi.weixin.qq.com/cgi-bin/get_jsapi_ticket?access_token=ACCESS_TOKEN";
        url = url.replace("ACCESS_TOKEN", token);

        return SendUtil.sendGet(msgPre, url, req, res, logger);
    }


    /**
     * 获取应用的jsapi_ticket。 <br/>
     *
     * @param agent 应用配置
     * @param req         请求体
     * @return 响应结果
     */
    public static InterfaceResult<JsapiTicketResForAgentConfig> getJsapiTicketForAgentConfig(Agent agent, JsapiTicketReqForAgentConfig req) {
        String logPrevDesc = agent.getLogPrevDesc();
        String token = agent.takeToken();

        return getJsapiTicketForAgentConfig(logPrevDesc, token, req);
    }


    /**
     * 获取应用的jsapi_ticket。 <br/>
     *
     * @param logPrevDesc 日志前缀描述
     * @param token       应用令牌
     * @param req         请求体
     * @return 响应结果
     */
    public static InterfaceResult<JsapiTicketResForAgentConfig> getJsapiTicketForAgentConfig(String logPrevDesc, String token, JsapiTicketReqForAgentConfig req) {
        String msgPre = logPrevDesc + ":" + "获取应用的jsapi_ticket: ";

        req.setBody(null);
        JsapiTicketResForAgentConfig res = new JsapiTicketResForAgentConfig();

        String url = "https://qyapi.weixin.qq.com/cgi-bin/ticket/get?access_token=ACCESS_TOKEN&type=agent_config";
        url = url.replace("ACCESS_TOKEN", token);

        return SendUtil.sendGet(msgPre, url, req, res, logger);
    }
}
