package cn.net.wanmo.common.weixin.work.inner.pojo.log;

import cn.net.wanmo.common.util.DateUtil;
import cn.net.wanmo.common.weixin.work.pojo.Token;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * Token 日志记录
 */
public class TokenLog {
    public static List<TokenLog> addressBookTokens = new ArrayList<>();
    public static List<TokenLog> agentTokens = new ArrayList<>();
    public static List<TokenLog> ticketTokens = new ArrayList<>();
    public static List<TokenLog> ticketConfigTokens = new ArrayList<>();

    /** 每个类型保存的最多个数 */
    private static int maxSize = 60;
    /** 添加 token 日志 */
    public static void add(String corpId, String agentId, String tokenType, Token token, List<TokenLog> list) {
        TokenLog log = new TokenLog();
        log.setCorpId(corpId);
        log.setAgentId(agentId);
        log.setTokenType(tokenType);
        log.setTokenValue(token.getValue());
        log.setErrCode(token.getCode());
        log.setErrMsg(token.getMsg());
        log.setResTime(DateUtil.formatDayTime(new Date(token.getResTime())));
        list.add(log);

        int size = list.size();
        for (int i = 0; i < size - maxSize; i++) {
            list.remove(0);
        }
    }


    private String corpId;
    private String agentId;
    private String tokenType;
    private String tokenValue;
    private String resTime;
    private String errCode;
    private String errMsg;

    public TokenLog() {
    }

    public String getCorpId() {
        return corpId;
    }

    public void setCorpId(String corpId) {
        this.corpId = corpId;
    }

    public String getAgentId() {
        return agentId;
    }

    public void setAgentId(String agentId) {
        this.agentId = agentId;
    }

    public String getTokenType() {
        return tokenType;
    }

    public void setTokenType(String tokenType) {
        this.tokenType = tokenType;
    }

    public String getTokenValue() {
        return tokenValue;
    }

    public void setTokenValue(String tokenValue) {
        this.tokenValue = tokenValue;
    }

    public String getResTime() {
        return resTime;
    }

    public void setResTime(String resTime) {
        this.resTime = resTime;
    }

    public String getErrCode() {
        return errCode;
    }

    public void setErrCode(String errCode) {
        this.errCode = errCode;
    }

    public String getErrMsg() {
        return errMsg;
    }

    public void setErrMsg(String errMsg) {
        this.errMsg = errMsg;
    }
}
