package cn.net.wanmo.common.weixin.work.inner.pojo.token;

import cn.net.wanmo.common.weixin.work.pojo.Token;

/**
 * 访问令牌
 * <pre>
 * access_token的有效期通过返回的expires_in来传达，正常情况下为7200秒（2小时），有效期内重复获取返回相同结果，过期后获取会返回新的access_token。
 * 由于企业微信每个应用的access_token是彼此独立的，所以进行缓存时需要区分应用来进行存储。
 * access_token至少保留512字节的存储空间。
 * 企业微信可能会出于运营需要，提前使access_token失效，开发者应实现access_token失效时重新获取的逻辑。
 * </prd>
 *
 * 令牌获取机制
 * <pre>
 *     获取令牌的任务线程中，
 * </pre>
 */
public class AccessToken extends Token {
    /** 企业ID */
    protected String corpId;
    /** 应用ID */
    protected String agentId;
    /** 令牌类型 */
    protected TokenType tokenType;

    public AccessToken() {
    }

    public AccessToken(String corpId) {
        this.corpId = corpId;
    }

    public AccessToken(String corpId, String agentId) {
        this.corpId = corpId;
        this.agentId = agentId;
    }

    public AccessToken(String token, Integer expiresIn, Long resTime) {
        this.value = token;
        this.expiresIn = expiresIn;
        this.resTime = resTime;
    }

    public AccessToken(String corpId, String token, Integer expiresIn, Long resTime) {
        this.corpId = corpId;
        this.value = token;
        this.expiresIn = expiresIn;
        this.resTime = resTime;
    }

    public AccessToken(String corpId, String agentId, String token, Integer expiresIn, Long resTime) {
        this.corpId = corpId;
        this.agentId = agentId;
        this.value = token;
        this.expiresIn = expiresIn;
        this.resTime = resTime;
    }

    public AccessToken(String corpId, String agentId, String token, Integer expiresIn, Long resTime, TokenType tokenType) {
        this.corpId = corpId;
        this.agentId = agentId;
        this.value = token;
        this.expiresIn = expiresIn;
        this.resTime = resTime;
        this.tokenType = tokenType;
    }

    public String getCorpId() {
        return corpId;
    }

    public void setCorpId(String corpId) {
        this.corpId = corpId;
    }

    public String getAgentId() {
        return agentId;
    }

    public void setAgentId(String agentId) {
        this.agentId = agentId;
    }

    public TokenType getTokenType() {
        return tokenType;
    }

    public void setTokenType(TokenType tokenType) {
        this.tokenType = tokenType;
    }

    public enum TokenType {
        agent("token_agent", "应用令牌"),
        address_book("token_address_book", "通讯录令牌");

        private final String value;
        private final String label;

        TokenType(String value, String label) {
            this.value = value;
            this.label = label;
        }

        public String getValue() {
            return value;
        }

        public String getLabel() {
            return label;
        }
    }
}
