package cn.net.wanmo.common.weixin.work.inner.server_api.pojo.address_book;

import cn.net.wanmo.common.restful.body.Req;
import com.alibaba.fastjson.JSONObject;

public class GetUseridByEmailReq extends Req {

    public static GetUseridByEmailReq build(String email) {
        return build(email, EmailType.enterprise);
    }

    public static GetUseridByEmailReq build(String email, EmailType emailType) {
        GetUseridByEmailReq req = new GetUseridByEmailReq();
        req.setEmail(email);
        req.setEmailType(emailType);
        return req;
    }

    @Override
    public String toJSONString() {
        JSONObject params = new JSONObject();
        params.put("email", getEmail());
        params.put("email_type", getEmailType().value);
        return params.toJSONString();
    }

    private String email;
    private EmailType emailType;

    public GetUseridByEmailReq() {
        this.emailType = EmailType.enterprise;
    }

    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public EmailType getEmailType() {
        return emailType;
    }

    public void setEmailType(EmailType emailType) {
        this.emailType = emailType;
    }

    public enum EmailType {
        enterprise(1, "企业邮箱"),
        personal(2, "个人邮箱");

        private final Integer value;
        private final String label;

        EmailType(Integer value, String label) {
            this.value = value;
            this.label = label;
        }

        public Integer getValue() {
            return value;
        }

        public String getLabel() {
            return label;
        }
    }
}
