package cn.net.wanmo.common.weixin.work.inner.server_api.pojo.address_book;

import cn.net.wanmo.common.restful.body.Req;
import com.alibaba.fastjson.JSONObject;

public class GetUseridByMobileReq extends Req {

    /**
     * 生成请求体
     * @param mobile 用户在企业微信通讯录中的手机号码。长度为5~32个字节
     * @return 请求体
     */
    public static GetUseridByMobileReq build(String mobile) {
        GetUseridByMobileReq req = new GetUseridByMobileReq();
        req.setMobile(mobile);
        return req;
    }

    @Override
    public String toJSONString() {
        JSONObject params = new JSONObject();
        params.put("mobile", getMobile());
        return params.toJSONString();
    }

    /** 用户在企业微信通讯录中的手机号码。长度为5~32个字节 */
    private String mobile;

    public GetUseridByMobileReq() {
    }

    public String getMobile() {
        return mobile;
    }

    public void setMobile(String mobile) {
        this.mobile = mobile;
    }
}
