package cn.net.wanmo.common.weixin.work.inner.server_api.pojo.authentication.web_auth;

import java.io.Serializable;

public class Oauth2UrlReq implements Serializable {
    /** 企业的CorpID */
    private String corpId;
    /** 应用agentid，建议填上该参数（对于第三方应用和代开发自建应用，在填写该参数的情况下或者在工作台、聊天工具栏、应用会话内发起oauth2请求的场景中，会触发接口许可的自动激活）。snsapi_privateinfo时必填否则报错； */
    private String agentId;
    /** 授权后重定向的回调链接地址 */
    private String redirectUri;
    /** 应用授权作用域 */
    private Scope scope;
    /** 重定向后会带上state参数，企业可以填写a-zA-Z0-9的参数值，长度不可超过128个字节 */
    private String state;

    public Oauth2UrlReq() {
    }

    public String getCorpId() {
        return corpId;
    }

    public void setCorpId(String corpId) {
        this.corpId = corpId;
    }

    public String getAgentId() {
        return agentId;
    }

    public void setAgentId(String agentId) {
        this.agentId = agentId;
    }

    public String getRedirectUri() {
        return redirectUri;
    }

    public void setRedirectUri(String redirectUri) {
        this.redirectUri = redirectUri;
    }

    public Scope getScope() {
        return scope;
    }

    public void setScope(Scope scope) {
        this.scope = scope;
    }

    public String getState() {
        return state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public enum Scope {
        snsapi_base("snsapi_base", "静默授权，可获取成员的基础信息（UserId与DeviceId）；"),
        snsapi_privateinfo("snsapi_privateinfo", "手动授权，可获取成员的详细信息，包含头像、二维码等敏感信息。");

        private final String value;
        private final String label;

        Scope(String value, String label) {
            this.value = value;
            this.label = label;
        }

        public String getValue() {
            return value;
        }

        public String getLabel() {
            return label;
        }
    }
}
