package cn.net.wanmo.common.weixin.work.inner.server_api.util.address_book;

import cn.net.wanmo.common.pojo.InterfaceResult;
import cn.net.wanmo.common.restful.SendUtil;
import cn.net.wanmo.common.weixin.work.inner.pojo.token.AccessToken;
import cn.net.wanmo.common.weixin.work.inner.server_api.pojo.address_book.*;
import cn.net.wanmo.common.weixin.work.inner.pojo.Corp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * 企业内部开发 -> 服务端API -> 通讯录管理 -> 成员管理 <br/>
 * <pre>
 *     1. 电脑端企业微信 -> 安全与管理 -> 管理工具 -> 通讯录同步 -> 开启;
 *     2. 查看 Secret;
 *     3. 企业可信IP配置;
 * </pre>
 *
 */
public class MemberUtil {
    private static Logger logger = LoggerFactory.getLogger(MemberUtil.class);

    /**
     * 创建成员
     */
    public static <AddressBookToken extends AccessToken> void createUser() {
        String url = "https://qyapi.weixin.qq.com/cgi-bin/user/create?access_token=ACCESS_TOKEN";
        // TODO 创建成员
    }

    /**
     * 读取成员 <br/>
     * 注： 通讯录查询接口停用
     *
     * @param corp 企业
     * @param req 请求体
     * @return 响应结果
     */
    @Deprecated
    public static <AddressBookToken extends AccessToken> InterfaceResult<GetUserRes> getUser(Corp<AddressBookToken> corp, GetUserReq req) {
        String logPrevDesc = corp.getLogPrevDesc();
        String token = corp.takeTokenForAddressBook();

        return getUser(logPrevDesc, token, req);
    }

    /**
     * 读取成员 <br/>
     * 注： 通讯录查询接口停用
     *
     * @param logPrevDesc 日志前缀描述
     * @param token    通讯录令牌
     * @param req 请求体
     * @return 响应结果
     */
    @Deprecated
    public static InterfaceResult<GetUserRes> getUser(String logPrevDesc, String token, GetUserReq req) {
        String msgPre = logPrevDesc + ":" + "通讯录管理 读取成员: ";

        req.setBody(req.toJSONString());
        GetUserRes res = new GetUserRes();

        String url = "https://qyapi.weixin.qq.com/cgi-bin/user/get?access_token=ACCESS_TOKEN&userid=USERID";
        url = url.replace("ACCESS_TOKEN", token).replace("USERID", req.getUserId());

        return SendUtil.sendPostForJson(msgPre, url, req, res, logger);
    }

    /**
     * 更新成员
     */
    public static <AddressBookToken extends AccessToken> void updateUser() {
        String url = "https://qyapi.weixin.qq.com/cgi-bin/user/update?access_token=ACCESS_TOKEN";
    }

    /**
     * 删除成员
     */
    public static <AddressBookToken extends AccessToken> void deleteUser() {
        String url = "https://qyapi.weixin.qq.com/cgi-bin/user/delete?access_token=ACCESS_TOKEN&userid=USERID";
    }

    /**
     * 批量删除成员
     */
    public static <AddressBookToken extends AccessToken> void batchDeleteUser() {
        String url = "https://qyapi.weixin.qq.com/cgi-bin/user/batchdelete?access_token=ACCESS_TOKEN";
    }

    /**
     * 获取部门成员
     */
    public static <AddressBookToken extends AccessToken> void simpleListByDeptId() {
        String url = "https://qyapi.weixin.qq.com/cgi-bin/user/simplelist?access_token=ACCESS_TOKEN&department_id=DEPARTMENT_ID";
    }

    /**
     * 获取部门成员详情
     */
    public static <AddressBookToken extends AccessToken> void listByDeptId() {
        String url = "https://qyapi.weixin.qq.com/cgi-bin/user/list?access_token=ACCESS_TOKEN&department_id=DEPARTMENT_ID";
    }

    /**
     * userid与openid互换
     */
    public static <AddressBookToken extends AccessToken> void convertToOpenid() {
        String url = "https://qyapi.weixin.qq.com/cgi-bin/user/convert_to_openid?access_token=ACCESS_TOKEN";
    }

    /**
     * 二次验证
     */
    public static <AddressBookToken extends AccessToken> void authSucc() {
        String url = "https://qyapi.weixin.qq.com/cgi-bin/user/authsucc?access_token=ACCESS_TOKEN&userid=USERID";

    }

    /**
     * 邀请成员<br/>
     * 企业可通过接口批量邀请成员使用企业微信，邀请后将通过短信或邮件下发通知。
     */
    public static <AddressBookToken extends AccessToken> void batchInvite() {
        String url = "https://qyapi.weixin.qq.com/cgi-bin/batch/invite?access_token=ACCESS_TOKEN";
    }

    /**
     * 获取加入企业二维码<br/>
     * 支持企业用户获取实时成员加入二维码。
     */
    public static <AddressBookToken extends AccessToken> void getJoinQrcode() {
        String url = "https://qyapi.weixin.qq.com/cgi-bin/corp/get_join_qrcode?access_token=ACCESS_TOKEN&size_type=SIZE_TYPE";
    }


    /**
     * 手机号获取userid<br/>
     * 通过手机号获取其所对应的userid。 <br/>
     * 注：请确保手机号的正确性，若出错的次数超出企业规模人数的20%，会导致1天不可调用。
     *
     * @param corp 企业
     * @param req 请求体
     * @return 响应结果
     */
    public static <AddressBookToken extends AccessToken> InterfaceResult<GetUseridByMobileRes> getUseridByMobile(Corp<AddressBookToken> corp, GetUseridByMobileReq req) {
        String logPrevDesc = corp.getLogPrevDesc();
        String token = corp.takeTokenForAddressBook();

        return getUseridByMobile(logPrevDesc, token, req);
    }


    /**
     * 手机号获取userid<br/>
     * 通过手机号获取其所对应的userid。 <br/>
     * 注：请确保手机号的正确性，若出错的次数超出企业规模人数的20%，会导致1天不可调用。
     *
     * @param logPrevDesc 日志前缀描述
     * @param token    通讯录令牌
     * @param req 请求体
     * @return 响应结果
     */
    public static InterfaceResult<GetUseridByMobileRes> getUseridByMobile(String logPrevDesc, String token, GetUseridByMobileReq req) {
        String msgPre = logPrevDesc + ":" + "通讯录管理 手机号获取userid: ";

        req.setBody(req.toJSONString());
        GetUseridByMobileRes res = new GetUseridByMobileRes();

        String url = "https://qyapi.weixin.qq.com/cgi-bin/user/getuserid?access_token=ACCESS_TOKEN";
        url = url.replace("ACCESS_TOKEN", token);

        return SendUtil.sendPostForJson(msgPre, url, req, res, logger);
    }


    /**
     * 邮箱获取userid <br/>
     * 通过邮箱获取其所对应的userid。 <br/>
     *注：请确保邮箱的正确性，若出错的次数较多，会导致1天不可调用。（限制阈值取决于安装企业的员工规模）
     *
     * @param corp 企业
     * @param req 请求体
     * @return 响应结果
     */
    public static <AddressBookToken extends AccessToken> InterfaceResult<GetUseridByEmailRes> getUseridByEmail(Corp<AddressBookToken> corp, GetUseridByEmailReq req) {
        String logPrevDesc = corp.getLogPrevDesc();
        String token = corp.takeTokenForAddressBook();

        return getUseridByEmail(logPrevDesc, token, req);
    }

    /**
     * 邮箱获取userid <br/>
     * 通过邮箱获取其所对应的userid。 <br/>
     *注：请确保邮箱的正确性，若出错的次数较多，会导致1天不可调用。（限制阈值取决于安装企业的员工规模）
     *
     * @param logPrevDesc 日志前缀描述
     * @param token    通讯录令牌
     * @param req 请求体
     * @return 响应结果
     */
    public static InterfaceResult<GetUseridByEmailRes> getUseridByEmail(String logPrevDesc, String token, GetUseridByEmailReq req) {
        String msgPre = logPrevDesc + ":" + "通讯录管理 邮箱获取userid: ";

        req.setBody(req.toJSONString());
        GetUseridByEmailRes res = new GetUseridByEmailRes();

        String url = "https://qyapi.weixin.qq.com/cgi-bin/user/get_userid_by_email?access_token=ACCESS_TOKEN";
        url = url.replace("ACCESS_TOKEN", token);

        return SendUtil.sendPostForJson(msgPre, url, req, res, logger);
    }

    /**
     * 获取成员ID列表<br/>
     * 获取企业成员的userid与对应的部门ID列表<br/>
     * 注：仅支持通过“通讯录同步secret”调用。<br/>
     *
     * @param corp 企业
     * @param req 请求体
     * @return 响应结果
     */
    public static <AddressBookToken extends AccessToken> InterfaceResult<ListIdRes> listId(Corp<AddressBookToken> corp, ListIdReq req) {
        String logPrevDesc = corp.getLogPrevDesc();
        String token = corp.takeTokenForAddressBook();

        return listId(logPrevDesc, token, req);
    }

    /**
     * 获取成员ID列表<br/>
     * 获取企业成员的userid与对应的部门ID列表<br/>
     * 注：仅支持通过“通讯录同步secret”调用。<br/>
     *
     * @param logPrevDesc 日志前缀描述
     * @param token    通讯录令牌
     * @param req 请求体
     * @return 响应结果
     */
    public static InterfaceResult<ListIdRes> listId(String logPrevDesc, String token, ListIdReq req) {
        String msgPre = logPrevDesc + ":" + "通讯录管理 获取成员ID列表: ";

        req.setBody(req.toJSONString());
        ListIdRes res = new ListIdRes();

        String url = "https://qyapi.weixin.qq.com/cgi-bin/user/list_id?access_token=ACCESS_TOKEN";
        url = url.replace("ACCESS_TOKEN", token);

        return SendUtil.sendPostForJson(msgPre, url, req, res, logger);
    }
}
