package cn.net.wanmo.common.weixin.work.inner.client_api.pojo.jsapi_ticket;

import cn.net.wanmo.common.restful.body.Res;
import cn.net.wanmo.common.weixin.work.inner.pojo.WechatRes;
import com.alibaba.fastjson.JSONObject;

/**
 * 获取 jsapi ticket 响应数据
 */
public class JsapiTicketResForAgent extends WechatRes {

    @Override
    public Res parse(JSONObject jsonObject) {
        super.parse(jsonObject);

        if (isSuccess() == false) {
            return this;
        }

        this.ticket = jsonObject.getString("ticket");
        this.expiresIn = jsonObject.getInteger("expires_in");

        return this;
    }

    private String ticket;
    private Integer expiresIn;

    public JsapiTicketResForAgent() {
    }

    public String getTicket() {
        return ticket;
    }

    public void setTicket(String ticket) {
        this.ticket = ticket;
    }

    public Integer getExpiresIn() {
        return expiresIn;
    }

    public void setExpiresIn(Integer expiresIn) {
        this.expiresIn = expiresIn;
    }
}
