package cn.net.wanmo.common.weixin.work.inner.pojo.log;

import cn.net.wanmo.common.util.DateUtil;
import cn.net.wanmo.common.weixin.work.pojo.Token;

import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

/**
 * Token 日志记录
 * 在执行获取令牌的线程时，会在内存中记录 指定数量 令牌获取的日志信息；
 */
public class TokenLog {
    /**
     * 通讯录令牌的记录
     */
    public static List<TokenLog> addressBookTokens = new ArrayList<>();
    /**
     * 应用令牌的记录
     */
    public static List<TokenLog> agentTokens = new ArrayList<>();
    /**
     * 前端票据的记录
     */
    public static List<TokenLog> ticketTokens = new ArrayList<>();
    /**
     * 前端票据配置的记录
     */
    public static List<TokenLog> ticketConfigTokens = new ArrayList<>();

    /**
     * 每个令牌类型保存日志的最多个数
     */
    private static int maxSize = 60;

    /**
     * 添加 token 日志;
     *
     * @param corpId    企业ID
     * @param agentId   应用ID
     * @param tokenType 令牌类型
     * @param token     令牌
     * @param list      待保存的令牌类型的集合
     */
    public static void add(String corpId, String agentId, String tokenType, Token token, List<TokenLog> list) {
        TokenLog log = new TokenLog();
        log.setCorpId(corpId);
        log.setAgentId(agentId);
        log.setTokenType(tokenType);
        log.setTokenValue(token.getValue());
        log.setErrCode(token.getCode());
        log.setErrMsg(token.getMsg());
        log.setResTime(DateUtil.formatDayTime(new Date(token.getResTime())));
        list.add(log);

        int size = list.size();
        for (int i = 0; i < size - maxSize; i++) {
            list.remove(0);
        }
    }

    /**
     * 企业ID
     */
    private String corpId;
    /**
     * 应用ID
     */
    private String agentId;
    /**
     * 令牌类型
     */
    private String tokenType;
    /**
     * 令牌值
     */
    private String tokenValue;
    /**
     * 响应时间
     */
    private String resTime;
    /**
     * 错误码
     */
    private String errCode;
    /**
     * 错误消息
     */
    private String errMsg;

    public TokenLog() {
    }

    public String getCorpId() {
        return corpId;
    }

    public void setCorpId(String corpId) {
        this.corpId = corpId;
    }

    public String getAgentId() {
        return agentId;
    }

    public void setAgentId(String agentId) {
        this.agentId = agentId;
    }

    public String getTokenType() {
        return tokenType;
    }

    public void setTokenType(String tokenType) {
        this.tokenType = tokenType;
    }

    public String getTokenValue() {
        return tokenValue;
    }

    public void setTokenValue(String tokenValue) {
        this.tokenValue = tokenValue;
    }

    public String getResTime() {
        return resTime;
    }

    public void setResTime(String resTime) {
        this.resTime = resTime;
    }

    public String getErrCode() {
        return errCode;
    }

    public void setErrCode(String errCode) {
        this.errCode = errCode;
    }

    public String getErrMsg() {
        return errMsg;
    }

    public void setErrMsg(String errMsg) {
        this.errMsg = errMsg;
    }
}
