package cn.net.wanmo.common.weixin.work.inner.server_api.pojo.message_push.app;

import cn.net.wanmo.common.restful.body.Res;
import cn.net.wanmo.common.weixin.work.inner.pojo.WechatRes;
import com.alibaba.fastjson.JSONObject;

public class MessageRes extends WechatRes {
    @Override
    public Res parse(JSONObject jsonObject) {
        super.parse(jsonObject);

        if (isSuccess() == false) {
            return this;
        }

        this.invalidUser = jsonObject.getString("invaliduser");
        this.invalidParty = jsonObject.getString("invalidparty");
        this.invalidTag = jsonObject.getString("invalidtag");
        this.unlicensedUser = jsonObject.getString("unlicenseduser");
        this.msgId = jsonObject.getString("msgid");
        this.responseCode = jsonObject.getString("response_code");

        return this;
    }

    /** 不合法的userid，不区分大小写，统一转为小写 */
    private String invalidUser;
    /** 不合法的partyid */
    private String invalidParty;
    /** 不合法的标签id */
    private String invalidTag;
    /** 没有基础接口许可(包含已过期)的userid */
    private String unlicensedUser;
    /** 消息id，用于撤回应用消息 */
    private String msgId;
    /** 仅消息类型为“按钮交互型”，“投票选择型”和“多项选择型”的模板卡片消息返回，应用可使用response_code调用更新模版卡片消息接口，72小时内有效，且只能使用一次 */
    private String responseCode;

    public MessageRes() {
    }

    public String getInvalidUser() {
        return invalidUser;
    }

    public void setInvalidUser(String invalidUser) {
        this.invalidUser = invalidUser;
    }

    public String getInvalidParty() {
        return invalidParty;
    }

    public void setInvalidParty(String invalidParty) {
        this.invalidParty = invalidParty;
    }

    public String getInvalidTag() {
        return invalidTag;
    }

    public void setInvalidTag(String invalidTag) {
        this.invalidTag = invalidTag;
    }

    public String getUnlicensedUser() {
        return unlicensedUser;
    }

    public void setUnlicensedUser(String unlicensedUser) {
        this.unlicensedUser = unlicensedUser;
    }

    public String getMsgId() {
        return msgId;
    }

    public void setMsgId(String msgId) {
        this.msgId = msgId;
    }

    public String getResponseCode() {
        return responseCode;
    }

    public void setResponseCode(String responseCode) {
        this.responseCode = responseCode;
    }
}
