package cn.net.wanmo.common.weixin.work.inner.server_api.util.authentication;

import cn.net.wanmo.common.codec.CodecUtil;
import cn.net.wanmo.common.result.InterfaceResult;
import cn.net.wanmo.common.restful.SendUtil;
import cn.net.wanmo.common.weixin.work.inner.server_api.pojo.authentication.web_auth.*;
import cn.net.wanmo.common.weixin.work.inner.pojo.Agent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * 网页授权登录
 */
public class WebAuthUtil {
    private static Logger logger = LoggerFactory.getLogger(WebAuthUtil.class);

    /**
     * 构造网页授权链接，回调地址接收参数( code, state )
     * @param req 请求参数
     * @return 构造后的 url
     */
    public static Oauth2UrlRes buildPageOauth2Url(Oauth2UrlReq req) {
        String corpId = req.getCorpId();
        String agentId = req.getAgentId();
        String redirectUri = CodecUtil.urlEncode(req.getRedirectUri());
        String scope = req.getScope().getValue();
        String state = req.getState();

        String url = "https://open.weixin.qq.com/connect/oauth2/authorize?appid=CORPID&redirect_uri=REDIRECT_URI&response_type=code&scope=SCOPE&state=STATE&agentid=AGENTID#wechat_redirect";
        url = url.replace("CORPID", corpId).replace("AGENTID", agentId).replace("REDIRECT_URI", redirectUri).replace("SCOPE", scope).replace("STATE", state);

        logger.debug("自建应用 构造网页授权链接 url: {}", url);
        return new Oauth2UrlRes(url);
    }

    /**
     * 网页授权登录 获取访问用户身份<br/>
     * 该接口用于根据code获取成员信息，适用于自建应用与代开发应用<br/>
     * 注：跳转的域名须完全匹配access_token对应应用的可信域名，否则会返回50001错误。
     *
     * @param agent 应用配置
     * @param req    请求体
     * @return 响应结果
     * <pre>
     *     cn.net.wanmo.common.weixin.work.inner.pojo.authentication.web_auth.GetUserinfoRes
     * </pre>
     */
    public static InterfaceResult<GetUserinfoRes> getUserinfo(Agent agent, GetUserinfoReq req) {
        String logPrevDesc = agent.getLogPrevDesc();
        String token = agent.takeToken();

        return getUserinfo(logPrevDesc, token, req);
    }

    /**
     * 网页授权登录 获取访问用户身份<br/>
     * 该接口用于根据code获取成员信息，适用于自建应用与代开发应用<br/>
     * 注：跳转的域名须完全匹配access_token对应应用的可信域名，否则会返回50001错误。
     *
     * @param logPrevDesc 日志前缀描述
     * @param token    应用令牌
     * @param req    请求体
     * @return 响应结果
     * <pre>
     *     cn.net.wanmo.common.weixin.work.inner.pojo.authentication.web_auth.GetUserinfoRes
     * </pre>
     */
    public static InterfaceResult<GetUserinfoRes> getUserinfo(String logPrevDesc, String token, GetUserinfoReq req) {
        String msgPre = logPrevDesc + ": " + "网页授权登录 获取访问用户身份: ";

        req.setBody(null);
        GetUserinfoRes res = new GetUserinfoRes();

        String url = "https://qyapi.weixin.qq.com/cgi-bin/auth/getuserinfo?access_token=ACCESS_TOKEN&code=CODE";
        url = url.replace("ACCESS_TOKEN", token).replace("CODE", req.getCode());

        return SendUtil.sendGet(msgPre, url, req, res, logger);
    }

    /**
     * 网页授权登录 获取访问用户敏感信息<br/>
     * 自建应用与代开发应用可通过该接口获取成员授权的敏感字段<br/>
     * 注：注：对于自建应用与代开发应用，敏感字段需要管理员在应用详情里选择，且成员oauth2授权时确认后才返回。敏感字段包括：性别、头像、员工个人二维码、手机、邮箱、企业邮箱、地址。
     *
     * @param agent 应用配置
     * @param req    请求体
     * @return 响应结果
     * <pre>
     *     cn.net.wanmo.common.weixin.work.inner.pojo.authentication.web_auth.GetUserDetailRes
     * </pre>
     */
    public static InterfaceResult<GetUserDetailRes> getUserDetail(Agent agent, GetUserDetailReq req) {
        String logPrevDesc = agent.getLogPrevDesc();
        String token = agent.takeToken();

        return getUserDetail(logPrevDesc, token, req);
    }

    /**
     * 网页授权登录 获取访问用户敏感信息<br/>
     * 自建应用与代开发应用可通过该接口获取成员授权的敏感字段<br/>
     * 注：注：对于自建应用与代开发应用，敏感字段需要管理员在应用详情里选择，且成员oauth2授权时确认后才返回。敏感字段包括：性别、头像、员工个人二维码、手机、邮箱、企业邮箱、地址。
     *
     * @param logPrevDesc 日志前缀描述
     * @param token    应用令牌
     * @param req    请求体
     * @return 响应结果
     * <pre>
     *     cn.net.wanmo.common.weixin.work.inner.pojo.authentication.web_auth.GetUserDetailRes
     * </pre>
     */
    public static InterfaceResult<GetUserDetailRes> getUserDetail(String logPrevDesc, String token, GetUserDetailReq req) {
        String msgPre = logPrevDesc + ": " + "网页授权登录 获取访问用户敏感信息: ";

        req.setBody(req.toJSONString());
        GetUserDetailRes res = new GetUserDetailRes();

        String url = "https://qyapi.weixin.qq.com/cgi-bin/auth/getuserdetail?access_token=ACCESS_TOKEN";
        url = url.replace("ACCESS_TOKEN", token);
        return SendUtil.sendPostForJson(msgPre, url, req, res, logger);
    }
}
