package cn.net.wanmo.common.weixin.work.inner.server_api.pojo.address_book;

import cn.net.wanmo.common.restful.body.Res;
import cn.net.wanmo.common.weixin.work.inner.pojo.WechatRes;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;

import java.util.List;

public class DeptSimpleListRes extends WechatRes {

    @Override
    public Res parse(JSONObject jsonObject) {
        super.parse(jsonObject);
        if (isSuccess() == false) {
            return this;
        }

        JSONArray array = jsonObject.getJSONArray("department_id");
        if (array == null || array.size() == 0) {
            return this;
        }

        for (int i = 0; i < array.size(); i++) {
            JSONObject object = array.getJSONObject(i);

            DeptId deptId = new DeptId();
            deptId.setId(object.getString("id"));
            deptId.setParentId(object.getString("parentid"));
            deptId.setOrder(object.getIntValue("order"));

            this.deptIds.add(deptId);
        }

        return this;
    }

    private List<DeptId> deptIds;

    public DeptSimpleListRes() {
        this.deptIds = Lists.newArrayList();
    }

    public List<DeptId> getDeptIds() {
        return deptIds;
    }

    public void setDeptIds(List<DeptId> deptIds) {
        this.deptIds = deptIds;
    }

    public class DeptId {
        /**
         * 创建的部门id
         */
        private String id;
        /**
         * 父部门id。根部门为1。
         */
        private String parentId;
        /**
         * 在父部门中的次序值。order值大的排序靠前。值范围是[0, 2^32)。
         */
        private int order;

        public DeptId() {
        }

        public String getId() {
            return id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getParentId() {
            return parentId;
        }

        public void setParentId(String parentId) {
            this.parentId = parentId;
        }

        public int getOrder() {
            return order;
        }

        public void setOrder(int order) {
            this.order = order;
        }
    }

}
