package cn.net.wanmo.common.weixin.work.inner.server_api.util;

import cn.net.wanmo.common.result.InterfaceResult;
import cn.net.wanmo.common.restful.SendUtil;
import cn.net.wanmo.common.weixin.work.inner.pojo.Agent;
import cn.net.wanmo.common.weixin.work.inner.server_api.pojo.server_ip.ApiDomainIpReq;
import cn.net.wanmo.common.weixin.work.inner.server_api.pojo.server_ip.ApiDomainIpRes;
import cn.net.wanmo.common.weixin.work.inner.server_api.pojo.server_ip.CallbackIpReq;
import cn.net.wanmo.common.weixin.work.inner.server_api.pojo.server_ip.CallbackIpRes;
import cn.net.wanmo.common.weixin.work.inner.server_api.pojo.token.AccessTokenReq;
import cn.net.wanmo.common.weixin.work.inner.server_api.pojo.token.AccessTokenRes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * 企业内部开发工具类
 */
public class WorkInnerUtil {
    private static Logger logger = LoggerFactory.getLogger(WorkInnerUtil.class);




    /**
     * <br /> 为了安全考虑，开发者 请勿 将 access_token 返回给前端，需要开发者保存在后台，所有访问企业微信api的请求由后台发起。
     * <br />
     * <br /> 每个应用有独立的secret，获取到的access_token只能本应用使用，所以每个应用的access_token应该分开来获取。
     *
     * @param req 请求体
     * @return 接口实际响应的结果
     * <pre>
     *     cn.net.wanmo.common.weixin.work.inner.pojo.token.AccessToken
     * </pre>
     */
    public static InterfaceResult<AccessTokenRes> getAccessToken(AccessTokenReq req) {
        String msgPre = "企业微信接口 获取访问令牌: ";

        req.setBody(null);
        AccessTokenRes res = new AccessTokenRes();

        String url = "https://qyapi.weixin.qq.com/cgi-bin/gettoken?corpid=ID&corpsecret=SECRET";
        url = url.replace("ID", req.getCorpId()).replace("SECRET", req.getSecret());

        return SendUtil.sendGet(msgPre, url, req, res, logger);
    }


    /**
     * 获取企业微信接口IP段
     * <pre>
     *     API域名IP即qyapi.weixin.qq.com的解析地址，由开发者调用企业微信端的接入IP。如果企业需要做防火墙配置，那么可以通过这个接口获取到所有相关的IP段。IP段有变更可能，当IP段变更时，新旧IP段会同时保留一段时间。建议企业每天定时拉取IP段，更新防火墙设置，避免因IP段变更导致网络不通。
     * </pre>
     * @param agent 应用配置
     * @param req 请求体
     * @return 响应结果
     * <pre>
     *     cn.net.wanmo.common.weixin.work.inner.pojo.ApiDomainIp
     * </pre>
     */
    public static InterfaceResult<ApiDomainIpRes> getApiDomainIp(Agent agent, ApiDomainIpReq req) {
        String logPrevDesc = agent.getLogPrevDesc();
        String token = agent.takeToken();

        return getApiDomainIp(logPrevDesc, token, req);
    }

    /**
     * 获取企业微信接口IP段
     * <pre>
     *     API域名IP即qyapi.weixin.qq.com的解析地址，由开发者调用企业微信端的接入IP。如果企业需要做防火墙配置，那么可以通过这个接口获取到所有相关的IP段。IP段有变更可能，当IP段变更时，新旧IP段会同时保留一段时间。建议企业每天定时拉取IP段，更新防火墙设置，避免因IP段变更导致网络不通。
     * </pre>
     * @param logPrevDesc 日志前缀描述
     * @param token    应用令牌
     * @param req 请求体
     * @return 响应结果
     * <pre>
     *     cn.net.wanmo.common.weixin.work.inner.pojo.ApiDomainIp
     * </pre>
     */
    public static InterfaceResult<ApiDomainIpRes> getApiDomainIp(String logPrevDesc, String token, ApiDomainIpReq req) {
        String msgPre = logPrevDesc + ": " + "获取企业微信接口IP段: ";

        req.setBody(null);
        ApiDomainIpRes res = new ApiDomainIpRes();

        String url = "https://qyapi.weixin.qq.com/cgi-bin/get_api_domain_ip?access_token=ACCESS_TOKEN";
        url = url.replace("ACCESS_TOKEN", token);

        return SendUtil.sendGet(msgPre, url, req, res, logger);
    }

    /**
     * 获取企业微信回调IP段
     * <pre>
     *     企业微信在回调企业指定的URL时，是通过特定的IP发送出去的。如果企业需要做防火墙配置，那么可以通过这个接口获取到所有相关的IP段。IP段有变更可能，当IP段变更时，新旧IP段会同时保留一段时间。建议企业每天定时拉取IP段，更新防火墙设置，避免因IP段变更导致网络不通。
     * </pre>
     * @param agent 应用配置
     * @param req 请求体
     * @return 响应结果
     * <pre>
     *     cn.net.wanmo.common.weixin.work.inner.pojo.CallbackIp
     * </pre>
     */
    public static InterfaceResult<CallbackIpRes> getCallbackIp(Agent agent, CallbackIpReq req) {
        String logPrevDesc = agent.getLogPrevDesc();
        String token = agent.takeToken();

        return getCallbackIp(logPrevDesc, token, req);
    }

    /**
     * 获取企业微信回调IP段
     * <pre>
     *     企业微信在回调企业指定的URL时，是通过特定的IP发送出去的。如果企业需要做防火墙配置，那么可以通过这个接口获取到所有相关的IP段。IP段有变更可能，当IP段变更时，新旧IP段会同时保留一段时间。建议企业每天定时拉取IP段，更新防火墙设置，避免因IP段变更导致网络不通。
     * </pre>
     * @param logPrevDesc 日志前缀描述
     * @param token    应用令牌
     * @param req 请求体
     * @return 响应结果
     * <pre>
     *     cn.net.wanmo.common.weixin.work.inner.pojo.CallbackIp
     * </pre>
     */
    public static InterfaceResult<CallbackIpRes> getCallbackIp(String logPrevDesc, String token, CallbackIpReq req) {
        String msgPre = logPrevDesc + ": " + "获取企业微信回调IP段: ";

        req.setBody(null);
        CallbackIpRes res = new CallbackIpRes();

        String url = "https://qyapi.weixin.qq.com/cgi-bin/getcallbackip?access_token=ACCESS_TOKEN";
        url = url.replace("ACCESS_TOKEN", token);

        return SendUtil.sendGet(msgPre, url, req, res, logger);
    }

}
