package cn.net.wanmo.common.weixin.work.inner.server_api.util.address_book;

import cn.net.wanmo.common.restful.SendUtil;
import cn.net.wanmo.common.result.InterfaceResult;
import cn.net.wanmo.common.util.StringUtil;
import cn.net.wanmo.common.weixin.work.inner.pojo.Corp;
import cn.net.wanmo.common.weixin.work.inner.pojo.token.AccessToken;
import cn.net.wanmo.common.weixin.work.inner.server_api.pojo.address_book.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * 需配置IP白名单：
 * 应用管理：企业可信IP;
 * 安全管理：通讯录同步 -> 企业可信IP;
 */
public class DepartmentUtil {
    private static Logger logger = LoggerFactory.getLogger(DepartmentUtil.class);


    /**
     * 创建部门
     *
     * @param corp 企业
     * @param req  请求体
     * @return 响应结果
     */
    public static <AddressBookToken extends AccessToken> InterfaceResult<DeptCreateRes> createDept(Corp<AddressBookToken> corp, DeptCreateReq req) {
        String logPrevDesc = corp.getLogPrevDesc();
        String token = corp.takeTokenForAddressBook();

        return createDept(logPrevDesc, token, req);
    }

    /**
     * 创建部门<br/>
     *
     * @param token 通讯录令牌
     * @param req   请求体
     * @return 响应结果
     */
    public static <AddressBookToken extends AccessToken> InterfaceResult<DeptCreateRes> createDept(String token, DeptCreateReq req) {
        return createDept(null, token, req);
    }

    /**
     * 创建部门<br/>
     *
     * @param logPrevDesc 日志前缀描述
     * @param token       通讯录令牌
     * @param req         请求体
     * @return 响应结果
     */
    public static <AddressBookToken extends AccessToken> InterfaceResult<DeptCreateRes> createDept(String logPrevDesc, String token, DeptCreateReq req) {
        String msgPre = (StringUtil.isBlank(logPrevDesc) ? "" : (logPrevDesc + ":")) + "通讯录管理 创建部门: ";

        req.setBody(req.toJSONString());
        DeptCreateRes res = new DeptCreateRes();

        String url = "https://qyapi.weixin.qq.com/cgi-bin/department/create?access_token=ACCESS_TOKEN";
        url = url.replace("ACCESS_TOKEN", token);

        return SendUtil.sendPostForJson(msgPre, url, req, res, logger);
    }

    /**
     * 更新部门
     */
    public static <AddressBookToken extends AccessToken> void updateDept() {
        String url = "https://qyapi.weixin.qq.com/cgi-bin/department/update?access_token=ACCESS_TOKEN";
        // TODO 更新部门
    }

    /**
     * 删除部门
     */
    public static <AddressBookToken extends AccessToken> void deleteDept() {
        String url = "https://qyapi.weixin.qq.com/cgi-bin/department/delete?access_token=ACCESS_TOKEN&id=ID";
        // TODO 删除部门
    }

    /**
     * 获取子部门ID列表<br/>
     *
     * @param corp 企业
     * @param req  请求体
     * @return 响应结果
     */
    public static <AddressBookToken extends AccessToken> InterfaceResult<DeptSimpleListRes> simpleList(Corp<AddressBookToken> corp, DeptSimpleListReq req) {
        String logPrevDesc = corp.getLogPrevDesc();
        String token = corp.takeTokenForAddressBook();

        return simpleList(logPrevDesc, token, req);
    }

    /**
     * 获取子部门ID列表<br/>
     *
     * @param token 通讯录令牌
     * @param req   请求体
     * @return 响应结果
     */
    public static <AddressBookToken extends AccessToken> InterfaceResult<DeptSimpleListRes> simpleList(String token, DeptSimpleListReq req) {
        return simpleList(null, token, req);
    }

    /**
     * 获取子部门ID列表<br/>
     *
     * @param logPrevDesc 日志前缀描述
     * @param token       通讯录令牌
     * @param req         请求体
     * @return 响应结果
     */
    public static <AddressBookToken extends AccessToken> InterfaceResult<DeptSimpleListRes> simpleList(String logPrevDesc, String token, DeptSimpleListReq req) {
        String msgPre = (StringUtil.isBlank(logPrevDesc) ? "" : (logPrevDesc + ":")) + "通讯录管理 获取子部门ID列表: ";

        DeptSimpleListRes res = new DeptSimpleListRes();

        String url = "https://qyapi.weixin.qq.com/cgi-bin/department/simplelist?access_token=ACCESS_TOKEN&id=ID";
        url = url.replace("ACCESS_TOKEN", token);
        url = url.replace("ID", StringUtil.isBlank(req.getId()) ? "" : req.getId());

        return SendUtil.sendGet(msgPre, url, req, res, logger);

    }

}
