package cn.net.wanmo.common.weixin.work.third.util;

import cn.net.wanmo.common.http.HttpUtil;
import cn.net.wanmo.common.http.pojo.ResData;
import cn.net.wanmo.common.result.HttpResult;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * 在第三方应用开发提供的接口中，会涉及到三种类型的access_token
 */
public class AccessTokenUtil {
    private static Logger logger = LoggerFactory.getLogger(AccessTokenUtil.class);

    /**
     * 用于服务商级别的接口调用，比如登录授权、推广二维码等。
     * @param corpId 服务商的 corpId
     * @param providerSecret 服务商的 secret ，在服务商管理后台可见
     * @return 服务商的 provider_access_token
     */
    public static JSONObject getProviderAccessToken(String corpId, String providerSecret) {
        String url = "https://qyapi.weixin.qq.com/cgi-bin/service/get_provider_token";

        JSONObject jsonObjectReq = new JSONObject();
        jsonObjectReq.put("corpid", corpId);
        jsonObjectReq.put("provider_secret", providerSecret);

        JSONObject jsonObjectRes = new JSONObject();

        return jsonObjectRes;
    }

    /**
     * 应用授权的 suite_access_token
     * 企业在授权应用时，第三方需要以suite_id（第三方应用ID）、suite_secret（第三方应用密钥）（获取方法为：登录服务商管理后台->标准应用服务->应用管理栏，点进某个应用即可看到）换取suite_access_token，再以suite_access_token访问应用授权的接口
     *
     * @param suiteId
     * @param suiteSecret
     * @param suiteTicket
     * @return JSONObject (errcode, errmsg, suite_access_token, expires_in)
     */
    public static JSONObject getSuiteAccessToken(String suiteId, String suiteSecret, String suiteTicket) {
        String url = "https://qyapi.weixin.qq.com/cgi-bin/service/get_suite_token";

        JSONObject jsonObjectReq = new JSONObject();
        jsonObjectReq.put("suite_id", suiteId);
        jsonObjectReq.put("suite_secret", suiteSecret);
        jsonObjectReq.put("suite_ticket", suiteTicket);

        JSONObject jsonObjectRes = new JSONObject();

        HttpResult<ResData> result = HttpUtil.postJson(url, jsonObjectReq.toJSONString());
        if (result.isSuccess()) {
            String body = result.getData().getBody();
            logger.debug("获取 suite_access_token 请求 http 成功：{}" , body);

            jsonObjectRes = JSON.parseObject(body);
            int errcode = jsonObjectRes.getIntValue("errcode");
            String errmsg = jsonObjectRes.getString("errmsg");
            String suiteAccessToken = jsonObjectRes.getString("suite_access_token");
            Integer expiresIn = jsonObjectRes.getInteger("expires_in");
            if (errcode == 0) {
                logger.debug("获取 suite_access_token 成功： {}，有效时常： {}", suiteAccessToken, expiresIn);
            } else {
                logger.debug("获取 suite_access_token 失败： {}，错误码： {}", errmsg, errcode);
            }
        } else {
            jsonObjectRes.put("errcode", -1);
            jsonObjectRes.put("errmsg", result.getMsg());
            logger.error("获取 suite_access_token 请求 http 失败：{}", result.getMsg());
        }

        return jsonObjectRes;
    }

}
