package cn.net.wanmo.common.weixin.work.third.web;

import cn.net.wanmo.common.weixin.work.third.ThirdConfig;
import com.qq.weixin.mp.aes.AesException;
import com.qq.weixin.mp.aes.WXBizMsgCrypt;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;


/**
 * 回调配置
 */
public class ThirdCallbackConfigController {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());

    /**
     * 仅用于在应用创建配置应用信息时的验证，企业微信服务端会向回调URL发起一个 Get 请求，当该回调URL按照约定进行了响应后，表明第三方服务具备解析企业微信推送消息的能力。
     */
    public String data_verify(ThirdConfig config, String msg_signature, String timestamp, String nonce, String echostr) {
        return verify(config, msg_signature, timestamp, nonce, echostr);
    }

    /**
     * 用于实际的业务请求，比如应用菜单的点击事件，用户消息等。当有回调的行为发生时，企业微信服务端会向该回调URL发起一个 Post 请求，同时数据会已加密的形式推送到该回调 URL，第三方服务商接受信息、解密信息，处理业务逻辑，并且按照约定进行响应即可。
     */
    public String data_business() {
        return "success";
    }

    /**
     * 仅用于在应用创建配置应用信息时的验证，企业微信服务端会向回调URL发起一个 Get 请求，当该回调URL按照约定进行了响应后，表明第三方服务具备解析企业微信推送消息的能力。
     */
    public String command_verify(ThirdConfig config, String msg_signature, String timestamp, String nonce, String echostr) {
        return verify(config, msg_signature, timestamp, nonce, echostr);
    }

    /**
     * 用于实际的业务请求，比如应用菜单的点击事件，用户消息等。当有回调的行为发生时，企业微信服务端会向该回调URL发起一个 Post 请求，同时数据会已加密的形式推送到该回调 URL，第三方服务商接受信息、解密信息，处理业务逻辑，并且按照约定进行响应即可。
     */
    public String command_business() {
        return "success";
    }

    /**
     * Url 验证，并解密 echostr
     * @param config 配置信息
     * @param msg_signature 企业微信加密签名，msg_signature计算结合了企业填写的token、请求中的timestamp、nonce、加密的消息体。
     * @param timestamp 时间戳。与nonce结合使用，用于防止请求重放攻击。
     * @param nonce 随机数。与timestamp结合使用，用于防止请求重放攻击。
     * @param echostr 加密的字符串。需要解密得到消息内容明文，解密后有random、msg_len、msg、receiveid四个字段，其中msg即为消息内容明文
     * @return 消息内容明文
     */
    private String verify(ThirdConfig config, String msg_signature, String timestamp, String nonce, String echostr) {
        try {
            logger.debug("msg_signature = {}", msg_signature);
            logger.debug("timestamp = {}", timestamp);
            logger.debug("nonce = {}", nonce);
            logger.debug("echostr = {}", echostr);

            /*
             * 加解密库里，ReceiveId 在各个场景的含义不同：
             * 企业应用的回调，表示corpid
             * 第三方事件的回调，表示suiteid
             * 机器人场景的回调，是一个空字符串
             */
            WXBizMsgCrypt wxBizMsgCrypt = new WXBizMsgCrypt(config.getToken(), config.getEncodingAESKey(), "");
            return wxBizMsgCrypt.VerifyURL(msg_signature, timestamp, nonce, echostr);
        } catch (AesException e) {
            throw new RuntimeException(e);
        }
    }
}
