/*
 * Decompiled with CFR 0.152.
 */
package cn.net.wanmo.common.weixin.work.inner.pojo.log;

import cn.net.wanmo.common.util.DateUtil;
import cn.net.wanmo.common.util.StringUtil;
import cn.net.wanmo.common.weixin.work.pojo.Token;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TokenLog {
    public static Map<String, List<TokenLog>> addressBookTokenMap = new HashMap<String, List<TokenLog>>();
    public static Map<String, List<TokenLog>> agentTokenMap = new HashMap<String, List<TokenLog>>();
    public static Map<String, List<TokenLog>> ticketTokenMap = new HashMap<String, List<TokenLog>>();
    public static Map<String, List<TokenLog>> ticketConfigTokenMap = new HashMap<String, List<TokenLog>>();
    private static int maxSize = 6;
    private String corpId;
    private String agentId;
    private String tokenType;
    private String tokenValue;
    private String resTime;
    private String errCode;
    private String errMsg;

    public static List<TokenLog> get(String corpId, String agentId, Map<String, List<TokenLog>> map) {
        List<TokenLog> list = map.getOrDefault(TokenLog.getKey(corpId, agentId), Lists.newArrayList());
        Collections.reverse(list);
        return list;
    }

    public static void put(String corpId, String agentId, String tokenType, Token token, Map<String, List<TokenLog>> map) {
        List<TokenLog> list = map.getOrDefault(TokenLog.getKey(corpId, agentId), Lists.newArrayList());
        TokenLog log = new TokenLog();
        log.setCorpId(corpId);
        log.setAgentId(agentId);
        log.setTokenType(tokenType);
        log.setTokenValue(token.getValue());
        log.setErrCode(token.getCode());
        log.setErrMsg(token.getMsg());
        log.setResTime(DateUtil.formatDayTime((Date)new Date(token.getResTime())));
        list.add(log);
        int size = list.size();
        for (int i = 0; i < size - maxSize; ++i) {
            list.remove(0);
        }
        map.put(TokenLog.getKey(corpId, agentId), list);
    }

    private static String getKey(String corpId, String agentId) {
        if (StringUtil.isBlank((CharSequence)agentId)) {
            return corpId;
        }
        return corpId + "-" + agentId;
    }

    public String getCorpId() {
        return this.corpId;
    }

    public void setCorpId(String corpId) {
        this.corpId = corpId;
    }

    public String getAgentId() {
        return this.agentId;
    }

    public void setAgentId(String agentId) {
        this.agentId = agentId;
    }

    public String getTokenType() {
        return this.tokenType;
    }

    public void setTokenType(String tokenType) {
        this.tokenType = tokenType;
    }

    public String getTokenValue() {
        return this.tokenValue;
    }

    public void setTokenValue(String tokenValue) {
        this.tokenValue = tokenValue;
    }

    public String getResTime() {
        return this.resTime;
    }

    public void setResTime(String resTime) {
        this.resTime = resTime;
    }

    public String getErrCode() {
        return this.errCode;
    }

    public void setErrCode(String errCode) {
        this.errCode = errCode;
    }

    public String getErrMsg() {
        return this.errMsg;
    }

    public void setErrMsg(String errMsg) {
        this.errMsg = errMsg;
    }
}

