package cn.net.wanmo.common.weixin.work.inner.pojo;

import cn.net.wanmo.common.restful.body.Res;
import com.alibaba.fastjson.JSONObject;

/**
 * 调用企业微信官方接口，统一处理响应的数据结果
 */
public class WechatRes extends Res<Integer> {

    public WechatRes() {
    }

    public WechatRes(Integer errCode, String errMsg) {
        super(errCode, errMsg);
    }

    @Override
    public Integer defaultErrCode() {
        return 0;
    }

    @Override
    public Res parse(JSONObject jsonObject) {
        this.errCode = jsonObject.getIntValue("errcode");
        this.errMsg = jsonObject.getString("errmsg");
        return this;
    }

    @Override
    public boolean isSuccess() {
        return defaultErrCode().intValue() == getErrCode();
    }

    /**
     * 是否成功响应
     *
     * @return 是否
     */
    public boolean isOk() {
        return isSuccess();
    }
}
