package cn.net.wanmo.common.weixin.work.inner.server_api.pojo.address_book;

import cn.net.wanmo.common.restful.body.Res;
import cn.net.wanmo.common.util.StringUtil;
import cn.net.wanmo.common.weixin.work.inner.pojo.WechatRes;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/**
 * 增加标签成员
 */
public class TagAddUsersRes extends WechatRes {
    @Override
    public Res parse(JSONObject jsonObject) {
        super.parse(jsonObject);

        if (isSuccess() == false) {
            return this;
        }

        {
            String invalidlist = jsonObject.getString("invalidlist");
            if (StringUtil.isNotBlank(invalidlist)) {
                String[] split = invalidlist.split("\\|");
                this.invalidList = Arrays.asList(split);
            }
        }
        {
            JSONArray array = jsonObject.getJSONArray("invalidparty");
            if (array == null || array.isEmpty()) {

            } else {
                for (int i = 0; i < array.size(); i++) {
                    Integer partyId = array.getInteger(i);
                    this.invalidParty.add(partyId);
                }
            }
        }


        return this;
    }

    // ------------------------------------ 响应属性 ------------------------------------

    /** 非法的成员账号列表 */
    private List<String> invalidList;
    /** 非法的部门id列表 */
    private List<Integer> invalidParty;

    public TagAddUsersRes() {
        this.invalidList = new ArrayList<>();
        this.invalidParty = new ArrayList<>();
    }

    public List<String> getInvalidList() {
        return invalidList;
    }

    public void setInvalidList(List<String> invalidList) {
        this.invalidList = invalidList;
    }

    public List<Integer> getInvalidParty() {
        return invalidParty;
    }

    public void setInvalidParty(List<Integer> invalidParty) {
        this.invalidParty = invalidParty;
    }
}
