package cn.net.wanmo.common.weixin.work.inner.server_api.pojo.address_book;

import cn.net.wanmo.common.restful.body.Req;
import com.alibaba.fastjson.JSONObject;

/**
 * 创建标签
 */
public class TagCreateReq extends Req {
    public static TagCreateReq build(String tagName) {
        TagCreateReq req = new TagCreateReq();
        req.setTagName(tagName);
        return req;
    }

    @Override
    public String toJSONString() {
        JSONObject params = new JSONObject();
        params.put("tagid", this.tagId);
        params.put("tagname", this.tagName);
        return params.toJSONString();
    }

    // ------------------------------------ 请求属性 ------------------------------------

    /**
     * 标签ID <br/>
     * 非必填 <br/>
     * 标签id，非负整型，指定此参数时新增的标签会生成对应的标签id，不指定时则以目前最大的id自增。 <br/>
     */
    private Integer tagId;
    /**
     * 标签名 <br/>
     * 必填 <br/>
     * 标签名称，长度限制为32个字以内（汉字或英文字母），标签名不可与其他标签重名。 <br/>
     */
    private String tagName;

    public TagCreateReq() {
    }

    public Integer getTagId() {
        return tagId;
    }

    public void setTagId(Integer tagId) {
        this.tagId = tagId;
    }

    public String getTagName() {
        return tagName;
    }

    public void setTagName(String tagName) {
        this.tagName = tagName;
    }
}
