package cn.net.wanmo.common.weixin.work.inner.server_api.pojo.address_book;

import cn.net.wanmo.common.restful.body.Res;
import cn.net.wanmo.common.weixin.work.inner.pojo.WechatRes;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;

import java.util.ArrayList;
import java.util.List;

/**
 * 获取标签成员
 */
public class TagGetRes extends WechatRes {
    @Override
    public Res parse(JSONObject jsonObject) {
        super.parse(jsonObject);

        if (isSuccess() == false) {
            return this;
        }

        this.tagName = jsonObject.getString("tagname");

        { // 成员列表
            JSONArray array = jsonObject.getJSONArray("userlist");
            if (array == null || array.isEmpty()) {

            } else {
                for (int i = 0; i < array.size(); i++) {
                    JSONObject object = array.getJSONObject(i);

                    TagUser tagUser = new TagUser();
                    tagUser.setUserId(object.getString("userid"));
                    tagUser.setUserName(object.getString("name"));

                    this.userList.add(tagUser);
                }
            }
        }

        { // 部门id列表
            JSONArray array = jsonObject.getJSONArray("partylist");
            if (array == null || array.isEmpty()) {

            } else {
                for (int i = 0; i < array.size(); i++) {
                    Integer partyId = array.getInteger(i);
                    this.partyList.add(partyId);
                }
            }
        }

        return this;
    }

    // ------------------------------------ 响应属性 ------------------------------------
    /**
     * 标签名
     */
    private String tagName;
    /**
     * 标签中包含的成员列表
     */
    private List<TagUser> userList;
    /**
     * 标签中包含的部门id列表
     */
    private List<Integer> partyList;

    public TagGetRes() {
        this.userList = new ArrayList<>();
        this.partyList = new ArrayList<>();
    }

    public String getTagName() {
        return tagName;
    }

    public void setTagName(String tagName) {
        this.tagName = tagName;
    }

    public List<TagUser> getUserList() {
        return userList;
    }

    public void setUserList(List<TagUser> userList) {
        this.userList = userList;
    }

    public List<Integer> getPartyList() {
        return partyList;
    }

    public void setPartyList(List<Integer> partyList) {
        this.partyList = partyList;
    }

    /**
     * 标签用户
     */
    public class TagUser {
        /**
         * 成员账号
         */
        private String userId;
        /**
         * 成员名称
         */
        private String userName;

        public TagUser() {
        }

        public String getUserId() {
            return userId;
        }

        public void setUserId(String userId) {
            this.userId = userId;
        }

        public String getUserName() {
            return userName;
        }

        public void setUserName(String userName) {
            this.userName = userName;
        }
    }
}
