package cn.net.wanmo.common.weixin.work.inner.server_api.pojo.address_book;

import cn.net.wanmo.common.restful.body.Res;
import cn.net.wanmo.common.weixin.work.inner.pojo.WechatRes;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;

import java.util.ArrayList;
import java.util.List;

/**
 * 获取标签列表
 */
public class TagListRes extends WechatRes {
    @Override
    public Res parse(JSONObject jsonObject) {
        super.parse(jsonObject);

        if (isSuccess() == false) {
            return this;
        }

        { // 标签列表
            JSONArray array = jsonObject.getJSONArray("taglist");
            if (array == null || array.isEmpty()) {

            } else {
                for (int i = 0; i < array.size(); i++) {
                    JSONObject object = array.getJSONObject(i);

                    Tag tag = new Tag();
                    tag.setTagId(object.getInteger("tagid"));
                    tag.setUserName(object.getString("tagname"));

                    this.tagList.add(tag);
                }
            }
        }

        return this;
    }

    // ------------------------------------ 响应属性 ------------------------------------
    /**
     * 标签列表
     */
    private List<Tag> tagList;

    public TagListRes() {
        this.tagList = new ArrayList<>();
    }

    public List<Tag> getTagList() {
        return tagList;
    }

    public void setTagList(List<Tag> tagList) {
        this.tagList = tagList;
    }

    /**
     * 标签对象
     */
    public class Tag {
        /**
         * 标签id
         */
        private Integer tagId;
        /**
         * 标签名
         */
        private String userName;

        public Tag() {
        }

        public Integer getTagId() {
            return tagId;
        }

        public void setTagId(Integer tagId) {
            this.tagId = tagId;
        }

        public String getUserName() {
            return userName;
        }

        public void setUserName(String userName) {
            this.userName = userName;
        }
    }
}
