package cn.net.wanmo.common.weixin.work.inner.server_api.pojo.address_book;

import cn.net.wanmo.common.restful.body.Req;
import com.alibaba.fastjson.JSONObject;

/**
 * 更新标签名字
 */
public class TagUpdateReq extends Req {
    public static TagUpdateReq build(Integer tagId, String tagName) {
        TagUpdateReq req = new TagUpdateReq();
        req.setTagId(tagId);
        req.setTagName(tagName);
        return req;
    }

    @Override
    public String toJSONString() {
        JSONObject params = new JSONObject();
        params.put("tagid", this.tagId);
        params.put("tagname", this.tagName);
        return params.toJSONString();
    }

    // ------------------------------------ 请求属性 ------------------------------------

    /**
     * 标签ID <br/>
     * 必填 <br/>
     * 标签ID。 <br/>
     */
    private Integer tagId;
    /**
     * 标签名 <br/>
     * 必填 <br/>
     * 标签名称，长度限制为32个字（汉字或英文字母），标签不可与其他标签重名。 <br/>
     */
    private String tagName;

    public TagUpdateReq() {
    }

    public Integer getTagId() {
        return tagId;
    }

    public void setTagId(Integer tagId) {
        this.tagId = tagId;
    }

    public String getTagName() {
        return tagName;
    }

    public void setTagName(String tagName) {
        this.tagName = tagName;
    }
}
