package cn.net.wanmo.common.weixin.work.inner.server_api.util.address_book;

import cn.net.wanmo.common.restful.SendUtil;
import cn.net.wanmo.common.result.InterfaceResult;
import cn.net.wanmo.common.util.StringUtil;
import cn.net.wanmo.common.weixin.work.inner.pojo.Corp;
import cn.net.wanmo.common.weixin.work.inner.pojo.token.AccessToken;
import cn.net.wanmo.common.weixin.work.inner.server_api.pojo.address_book.*;
import cn.net.wanmo.common.weixin.work.inner.server_api.util.WorkInnerUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * 通讯录管理：标签管理
 */
public class TagUtil {
    private static Logger logger = LoggerFactory.getLogger(TagUtil.class);

    /**
     * 创建标签 <br/>
     *
     * @param corp 企业
     * @param req  请求体
     * @return 响应结果
     */
    @Deprecated
    public static <AddressBookToken extends AccessToken> InterfaceResult<TagCreateRes> create(Corp<AddressBookToken> corp, TagCreateReq req) {
        String logPrevDesc = corp.getLogPrevDesc();
        String token = corp.takeTokenForAddressBook();

        return create(logPrevDesc, token, req);
    }

    /**
     * 创建标签 <br/>
     *
     * @param token 通讯录令牌
     * @param req   请求体
     * @return 响应结果
     */
    @Deprecated
    public static InterfaceResult<TagCreateRes> create(String token, TagCreateReq req) {
        return create(null, token, req);
    }

    /**
     * 创建标签 <br/>
     *
     * @param logPrevDesc 日志前缀描述
     * @param token       通讯录令牌
     * @param req         请求体
     * @return 响应结果
     */
    @Deprecated
    public static InterfaceResult<TagCreateRes> create(String logPrevDesc, String token, TagCreateReq req) {
        String msgPre = WorkInnerUtil.getMsgPre(logPrevDesc, "通讯录管理 标签管理 创建标签: ");

        req.setBody(req.toJSONString());
        TagCreateRes res = new TagCreateRes();

        String url = "https://qyapi.weixin.qq.com/cgi-bin/tag/create?access_token=ACCESS_TOKEN";
        url = url.replace("ACCESS_TOKEN", token);

        return SendUtil.sendPostForJson(msgPre, url, req, res, logger);
    }


    /**
     * 更新标签名字 <br/>
     *
     * @param corp 企业
     * @param req  请求体
     * @return 响应结果
     */
    @Deprecated
    public static <AddressBookToken extends AccessToken> InterfaceResult<TagUpdateRes> update(Corp<AddressBookToken> corp, TagUpdateReq req) {
        String logPrevDesc = corp.getLogPrevDesc();
        String token = corp.takeTokenForAddressBook();

        return update(logPrevDesc, token, req);
    }

    /**
     * 更新标签名字 <br/>
     *
     * @param token 通讯录令牌
     * @param req   请求体
     * @return 响应结果
     */
    @Deprecated
    public static InterfaceResult<TagUpdateRes> update(String token, TagUpdateReq req) {
        return update(null, token, req);
    }

    /**
     * 更新标签名字 <br/>
     *
     * @param logPrevDesc 日志前缀描述
     * @param token       通讯录令牌
     * @param req         请求体
     * @return 响应结果
     */
    @Deprecated
    public static InterfaceResult<TagUpdateRes> update(String logPrevDesc, String token, TagUpdateReq req) {
        String msgPre = WorkInnerUtil.getMsgPre(logPrevDesc, "通讯录管理 标签管理 更新标签名字: ");

        req.setBody(req.toJSONString());
        TagUpdateRes res = new TagUpdateRes();

        String url = "https://qyapi.weixin.qq.com/cgi-bin/tag/update?access_token=ACCESS_TOKEN";
        url = url.replace("ACCESS_TOKEN", token);

        return SendUtil.sendPostForJson(msgPre, url, req, res, logger);
    }


    /**
     * 删除标签 <br/>
     *
     * @param corp 企业
     * @param req  请求体
     * @return 响应结果
     */
    @Deprecated
    public static <AddressBookToken extends AccessToken> InterfaceResult<TagDeleteRes> delete(Corp<AddressBookToken> corp, TagDeleteReq req) {
        String logPrevDesc = corp.getLogPrevDesc();
        String token = corp.takeTokenForAddressBook();

        return delete(logPrevDesc, token, req);
    }

    /**
     * 删除标签 <br/>
     *
     * @param token 通讯录令牌
     * @param req   请求体
     * @return 响应结果
     */
    @Deprecated
    public static InterfaceResult<TagDeleteRes> delete(String token, TagDeleteReq req) {
        return delete(null, token, req);
    }

    /**
     * 删除标签 <br/>
     *
     * @param logPrevDesc 日志前缀描述
     * @param token       通讯录令牌
     * @param req         请求体
     * @return 响应结果
     */
    @Deprecated
    public static InterfaceResult<TagDeleteRes> delete(String logPrevDesc, String token, TagDeleteReq req) {
        String msgPre = WorkInnerUtil.getMsgPre(logPrevDesc, "通讯录管理 标签管理 删除标签: ");

        req.setBody(null);
        TagDeleteRes res = new TagDeleteRes();

        String url = "https://qyapi.weixin.qq.com/cgi-bin/tag/delete?access_token=ACCESS_TOKEN&tagid=TAGID";
        url = url.replace("ACCESS_TOKEN", token).replace("TAGID", String.valueOf(req.getTagId()));

        return SendUtil.sendGet(msgPre, url, req, res, logger);
    }


    /**
     * 获取标签成员 <br/>
     *
     * @param corp 企业
     * @param req  请求体
     * @return 响应结果
     */
    @Deprecated
    public static <AddressBookToken extends AccessToken> InterfaceResult<TagGetRes> get(Corp<AddressBookToken> corp, TagGetReq req) {
        String logPrevDesc = corp.getLogPrevDesc();
        String token = corp.takeTokenForAddressBook();

        return get(logPrevDesc, token, req);
    }

    /**
     * 获取标签成员 <br/>
     *
     * @param token 通讯录令牌
     * @param req   请求体
     * @return 响应结果
     */
    @Deprecated
    public static InterfaceResult<TagGetRes> get(String token, TagGetReq req) {
        return get(null, token, req);
    }

    /**
     * 获取标签成员 <br/>
     *
     * @param logPrevDesc 日志前缀描述
     * @param token       通讯录令牌
     * @param req         请求体
     * @return 响应结果
     */
    @Deprecated
    public static InterfaceResult<TagGetRes> get(String logPrevDesc, String token, TagGetReq req) {
        String msgPre = WorkInnerUtil.getMsgPre(logPrevDesc, "通讯录管理 标签管理 获取标签成员: ");

        req.setBody(null);
        TagGetRes res = new TagGetRes();

        String url = "https://qyapi.weixin.qq.com/cgi-bin/tag/get?access_token=ACCESS_TOKEN&tagid=TAGID";
        url = url.replace("ACCESS_TOKEN", token).replace("TAGID", String.valueOf(req.getTagId()));

        return SendUtil.sendGet(msgPre, url, req, res, logger);
    }


    /**
     * 增加标签成员 <br/>
     *
     * @param corp 企业
     * @param req  请求体
     * @return 响应结果
     */
    @Deprecated
    public static <AddressBookToken extends AccessToken> InterfaceResult<TagAddUsersRes> addUsers(Corp<AddressBookToken> corp, TagAddUsersReq req) {
        String logPrevDesc = corp.getLogPrevDesc();
        String token = corp.takeTokenForAddressBook();

        return addUsers(logPrevDesc, token, req);
    }

    /**
     * 增加标签成员 <br/>
     *
     * @param token 通讯录令牌
     * @param req   请求体
     * @return 响应结果
     */
    @Deprecated
    public static InterfaceResult<TagAddUsersRes> addUsers(String token, TagAddUsersReq req) {
        return addUsers(null, token, req);
    }

    /**
     * 增加标签成员 <br/>
     *
     * @param logPrevDesc 日志前缀描述
     * @param token       通讯录令牌
     * @param req         请求体
     * @return 响应结果
     */
    @Deprecated
    public static InterfaceResult<TagAddUsersRes> addUsers(String logPrevDesc, String token, TagAddUsersReq req) {
        String msgPre = WorkInnerUtil.getMsgPre(logPrevDesc, "通讯录管理 标签管理 增加标签成员: ");

        req.setBody(req.toJSONString());
        TagAddUsersRes res = new TagAddUsersRes();

        String url = "https://qyapi.weixin.qq.com/cgi-bin/tag/addtagusers?access_token=ACCESS_TOKEN";
        url = url.replace("ACCESS_TOKEN", token);

        return SendUtil.sendPostForJson(msgPre, url, req, res, logger);
    }


    /**
     * 删除标签成员 <br/>
     *
     * @param corp 企业
     * @param req  请求体
     * @return 响应结果
     */
    @Deprecated
    public static <AddressBookToken extends AccessToken> InterfaceResult<TagDelUsersRes> delUsers(Corp<AddressBookToken> corp, TagDelUsersReq req) {
        String logPrevDesc = corp.getLogPrevDesc();
        String token = corp.takeTokenForAddressBook();

        return delUsers(logPrevDesc, token, req);
    }

    /**
     * 删除标签成员 <br/>
     *
     * @param token 通讯录令牌
     * @param req   请求体
     * @return 响应结果
     */
    @Deprecated
    public static InterfaceResult<TagDelUsersRes> delUsers(String token, TagDelUsersReq req) {
        return delUsers(null, token, req);
    }

    /**
     * 删除标签成员 <br/>
     *
     * @param logPrevDesc 日志前缀描述
     * @param token       通讯录令牌
     * @param req         请求体
     * @return 响应结果
     */
    @Deprecated
    public static InterfaceResult<TagDelUsersRes> delUsers(String logPrevDesc, String token, TagDelUsersReq req) {
        String msgPre = WorkInnerUtil.getMsgPre(logPrevDesc, "通讯录管理 标签管理 删除标签成员: ");

        req.setBody(req.toJSONString());
        TagDelUsersRes res = new TagDelUsersRes();

        String url = "https://qyapi.weixin.qq.com/cgi-bin/tag/deltagusers?access_token=ACCESS_TOKEN";
        url = url.replace("ACCESS_TOKEN", token);

        return SendUtil.sendPostForJson(msgPre, url, req, res, logger);
    }

    /**
     * 获取标签列表 <br/>
     *
     * @param corp 企业
     * @param req  请求体
     * @return 响应结果
     */
    @Deprecated
    public static <AddressBookToken extends AccessToken> InterfaceResult<TagListRes> list(Corp<AddressBookToken> corp, TagListReq req) {
        String logPrevDesc = corp.getLogPrevDesc();
        String token = corp.takeTokenForAddressBook();

        return list(logPrevDesc, token, req);
    }

    /**
     * 获取标签列表 <br/>
     *
     * @param token 通讯录令牌
     * @param req   请求体
     * @return 响应结果
     */
    @Deprecated
    public static InterfaceResult<TagListRes> list(String token, TagListReq req) {
        return list(null, token, req);
    }

    /**
     * 获取标签列表 <br/>
     *
     * @param logPrevDesc 日志前缀描述
     * @param token       通讯录令牌
     * @param req         请求体
     * @return 响应结果
     */
    @Deprecated
    public static InterfaceResult<TagListRes> list(String logPrevDesc, String token, TagListReq req) {
        String msgPre = WorkInnerUtil.getMsgPre(logPrevDesc, "通讯录管理 标签管理 获取标签列表: ");

        req.setBody(null);
        TagListRes res = new TagListRes();

        String url = "https://qyapi.weixin.qq.com/cgi-bin/tag/list?access_token=ACCESS_TOKEN";
        url = url.replace("ACCESS_TOKEN", token);

        return SendUtil.sendGet(msgPre, url, req, res, logger);
    }
}
