package cn.net.wanmo.common.weixin.work.pojo;

import java.io.Serializable;

public class Token implements Serializable {
    /** 令牌值 */
    protected String value;
    /** 凭证的有效时间（秒） */
    protected Integer expiresIn;
    /** 响应时间 */
    protected Long resTime;
    protected String code;
    protected String msg;

    public Token() {
    }

    public Token(String value, Integer expiresIn, Long resTime) {
        this.value = value;
        this.expiresIn = expiresIn;
        this.resTime = resTime;
    }

    public String getValue() {
        return value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public Integer getExpiresIn() {
        return expiresIn;
    }

    public void setExpiresIn(Integer expiresIn) {
        this.expiresIn = expiresIn;
    }

    public Long getResTime() {
        return resTime;
    }

    public void setResTime(Long resTime) {
        this.resTime = resTime;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getMsg() {
        return msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    /**
     * 子类实现,自定义存储令牌
     */
    public void storeToken() {
    }

    /**
     * 子类实现，自定义获取令牌。<br/>
     * 默认返回 getToken()
     * @return 令牌
     */
    public String takeToken() {
        return getValue();
    }
}
