package cn.net.wanmo.common.weixin.work.inner;

import cn.net.wanmo.common.weixin.work.inner.pojo.Agent;
import cn.net.wanmo.common.weixin.work.inner.pojo.Corp;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

/**
 * 用来封装自建应用配置信息
 */
public class InnerConfig implements Serializable {
    /**
     * 主键
     */
    private String id;
    /**
     * 自建应用的企业信息
     */
    private Corp corp;
    /**
     * 多个自建应用信息
     */
    private Map<String, Agent> agentMap = new HashMap<>();


    public InnerConfig() {
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Corp getCorp() {
        return corp;
    }

    public void setCorp(Corp corp) {
        this.corp = corp;
    }

    public Map<String, Agent> getAgentMap() {
        return agentMap;
    }

    public void setAgentMap(Map<String, Agent> agentMap) {
        this.agentMap = agentMap;
    }

    public Agent putAgent(String agentId, Agent agent) {
        return agentMap.put(agentId, agent);
    }

    public Agent getAgent(String agentId) {
        return agentMap.getOrDefault(agentId, new Agent());
    }

}
