package cn.net.wanmo.common.weixin.work.inner.enums.dict;

import cn.net.wanmo.common.util.StringUtil;

/**
 * 是否部门负责人
 */
public enum DemoEnum {
    unknown("", "未知"),
    yes("1", "部门负责人"),
    no("0", "非部门负责人");

    private final String value;
    private final String label;

    DemoEnum(String value, String label) {
        this.value = value;
        this.label = label;
    }

    public String getValue() {
        return value;
    }

    public String getLabel() {
        return label;
    }

    /**
     * 转为 对象
     *
     * @param value 值
     * @return 对象
     */
    public static DemoEnum changeOf(String value) {
        DemoEnum r = DemoEnum.unknown;

        DemoEnum[] values = DemoEnum.values();
        for (DemoEnum e : values) {
            if (StringUtil.equals(value, e.value)) {
                r = e;
                break;
            }
        }

        return r;
    }
}
