package cn.net.wanmo.common.weixin.work.inner.pojo.token;

import cn.net.wanmo.common.weixin.work.pojo.Token;

/**
 * 前端使用的 jsapi 票据
 */
public class TicketToken extends Token {
    /**
     * 企业ID
     */
    protected String corpId;
    /**
     * 应用ID
     */
    protected String agentId;
    /**
     * 票据类型
     */
    protected TokenType tokenType;

    public TicketToken() {
    }

    public TicketToken(String value, Integer expiresIn, Long resTime) {
        super(value, expiresIn, resTime);
    }

    public String getCorpId() {
        return corpId;
    }

    public void setCorpId(String corpId) {
        this.corpId = corpId;
    }

    public String getAgentId() {
        return agentId;
    }

    public void setAgentId(String agentId) {
        this.agentId = agentId;
    }

    public TokenType getTokenType() {
        return tokenType;
    }

    public void setTokenType(TokenType tokenType) {
        this.tokenType = tokenType;
    }

    public enum TokenType {
        jsapi_ticket("jsapi_ticket", "应用jsapi票据"),
        jsapi_ticket_config("jsapi_ticket_config", "应用jsapi配置票据");

        private final String value;
        private final String label;

        TokenType(String value, String label) {
            this.value = value;
            this.label = label;
        }

        public String getValue() {
            return value;
        }

        public String getLabel() {
            return label;
        }
    }
}
