package cn.net.wanmo.common.weixin.work.inner.server_api.pojo.address_book;

import cn.net.wanmo.common.restful.body.Req;
import cn.net.wanmo.common.weixin.work.inner.server_api.entity.address_book.User;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;

import java.util.List;

public class UserCreateReq extends Req {
    public static UserCreateReq build(User user) {
        UserCreateReq req = new UserCreateReq();
        req.setUser(user);
        return req;
    }

    @Override
    public String toJSONString() {
        JSONObject params = new JSONObject();

        params.put("userid", user.getUserid());
        params.put("name", user.getName());
        params.put("alias", user.getAlias());
        params.put("gender", user.getGender().getValue());
        params.put("avatar_mediaid", user.getAvatarMediaid());
        params.put("address", user.getAddress());
        params.put("telephone", user.getTelephone());
        params.put("mobile", user.getMobile());
        params.put("email", user.getEmail());
        params.put("biz_mail", user.getBizMail());
        params.put("to_invite", user.isToInvite());
        params.put("position", user.getPosition());
        {
            JSONArray is_leader_in_dept = new JSONArray();
            for (User.IsLeaderInDept isLeaderInDept : user.getIsLeaderInDepts()) {
                is_leader_in_dept.add(isLeaderInDept.getValue());
            }
            params.put("is_leader_in_dept", is_leader_in_dept);
        }
        {
            JSONArray direct_leader = new JSONArray();
            for (String directLeader : user.getDirectLeaders()) {
                direct_leader.add(directLeader);
            }
            params.put("direct_leader", direct_leader);
        }
        params.put("main_department", user.getMainDepartmentId());

        {
            JSONArray department = new JSONArray();
            for (Integer departmentId : user.getDepartmentIds()) {
                department.add(departmentId);
            }
            params.put("department", department);
        }
        {
            JSONArray order = new JSONArray();
            for (Integer e : user.getOrder()) {
                order.add(e);
            }
            params.put("order", order);
        }
        params.put("enable", user.getEnable().getValue());

        { // 自定义字段
            User.ExtProfile extProfile = user.getExtProfile();
            JSONObject extProfileJsonObj = new JSONObject();

            { // 设置扩展属性
                List<User.ExtProfile.ExtAttr> attrs = extProfile.getAttrs();
                JSONArray attrsJsonArray = new JSONArray();

                for (User.ExtProfile.ExtAttr attr : attrs) { // 遍历初始化 每个扩展属性
                    JSONObject attrJsonObj = new JSONObject();
                    attrJsonObj.put("type", attr.getType().getValue());
                    attrJsonObj.put("name", attr.getName());

                    switch (attr.getType()) {
                        case text:
                            User.ExtProfile.ExtAttr.Text text = attr.getText();
                            JSONObject textJsonObj = new JSONObject();
                            textJsonObj.put("value", text.getValue());

                            attrJsonObj.put("text", textJsonObj);
                            break;
                        case web:
                            User.ExtProfile.ExtAttr.Web web = attr.getWeb();
                            JSONObject webJsonObj = new JSONObject();
                            webJsonObj.put("title", web.getTitle());
                            webJsonObj.put("url", web.getUrl());

                            attrJsonObj.put("web", webJsonObj);
                            break;
                        default:
                            System.out.println();
                    }

                    attrsJsonArray.add(attrJsonObj);
                }

                extProfileJsonObj.put("attrs", attrsJsonArray);
            }

            params.put("extattr", extProfileJsonObj);
        }

        { // 成员对外属性
            User.ExternalProfile externalProfile = user.getExternalProfile();
            JSONObject externalProfileJsonObj = new JSONObject();
            externalProfileJsonObj.put("external_corp_name", externalProfile.getExternalCorpName());

            { // 视频号
                User.ExternalProfile.WechatChannels wechatChannels = externalProfile.getWechatChannels();
                JSONObject wechatChannelsJsonObj = new JSONObject();
                wechatChannelsJsonObj.put("nickname", wechatChannels.getNickname());

                externalProfileJsonObj.put("wechat_channels", wechatChannelsJsonObj);
            }

            { // 对外属性
                List<User.ExternalProfile.ExternalAttr> externalAttrs = externalProfile.getExternalAttrs();
                JSONArray externalAttrsJsonArray = new JSONArray();

                for (User.ExternalProfile.ExternalAttr externalAttr : externalAttrs) {
                    JSONObject externalAttrJsonObj = new JSONObject();
                    externalAttrJsonObj.put("type", externalAttr.getType().getValue());
                    externalAttrJsonObj.put("name", externalAttr.getName());

                    switch (externalAttr.getType()) {
                        case text:
                            User.ExternalProfile.ExternalAttr.Text text = externalAttr.getText();
                            JSONObject textJsonObj = new JSONObject();
                            textJsonObj.put("value", text.getValue());

                            externalAttrJsonObj.put("text", textJsonObj);
                            break;
                        case web:
                            User.ExternalProfile.ExternalAttr.Web web = externalAttr.getWeb();
                            JSONObject webJsonObj = new JSONObject();
                            webJsonObj.put("title", web.getTitle());
                            webJsonObj.put("url", web.getUrl());

                            externalAttrJsonObj.put("web", webJsonObj);
                            break;
                        case miniprogram:
                            User.ExternalProfile.ExternalAttr.Miniprogram miniprogram = externalAttr.getMiniprogram();
                            JSONObject miniprogramJsonObj = new JSONObject();
                            miniprogramJsonObj.put("title", miniprogram.getTitle());
                            miniprogramJsonObj.put("appid", miniprogram.getAppid());
                            miniprogramJsonObj.put("pagepath", miniprogram.getPagePath());

                            externalAttrJsonObj.put("miniprogram", miniprogramJsonObj);
                            break;
                        default:
                            System.out.println();
                    }

                    externalAttrsJsonArray.add(externalAttrJsonObj);
                }

                externalProfileJsonObj.put("external_attr", externalAttrsJsonArray);
            }

            params.put("external_profile", externalProfileJsonObj);
        }

        return params.toJSONString();
    }

    private User user;

    public UserCreateReq() {
    }

    public User getUser() {
        return user;
    }

    public void setUser(User user) {
        this.user = user;
    }
}
