package cn.net.wanmo.common.weixin.work.inner.server_api.pojo.address_book;

import cn.net.wanmo.common.restful.body.Res;
import cn.net.wanmo.common.weixin.work.inner.pojo.WechatRes;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;

import java.util.ArrayList;
import java.util.List;

public class UserListIdRes extends WechatRes {

    @Override
    public Res parse(JSONObject jsonObject) {
        super.parse(jsonObject);

        if (isSuccess() == false) {
            return this;
        }

        this.nextCursor = jsonObject.getString("next_cursor");
        JSONArray array = jsonObject.getJSONArray("dept_user");
        if (array == null || array.size() == 0) {
            return this;
        }

        for (int i = 0; i < array.size(); i++) {
            JSONObject object = array.getJSONObject(i);

            DeptUser deptUser = new DeptUser();
            deptUser.setUserid(object.getString("userid"));
            deptUser.setDepartment(object.getInteger("department"));

            this.deptUsers.add(deptUser);
        }

        return this;
    }

    /** 分页游标，下次请求时填写以获取之后分页的记录。如果该字段返回空则表示已没有更多数据 */
    private String nextCursor;
    /** 用户-部门关系列表 */
    private List<DeptUser> deptUsers = new ArrayList<>();

    public UserListIdRes() {
    }

    public String getNextCursor() {
        return nextCursor;
    }

    public void setNextCursor(String nextCursor) {
        this.nextCursor = nextCursor;
    }

    public List<DeptUser> getDeptUsers() {
        return deptUsers;
    }

    public void setDeptUsers(List<DeptUser> deptUsers) {
        this.deptUsers = deptUsers;
    }

    /**
     * 用户-部门关系列表
     */
    public class DeptUser {
        /** 用户userid，当用户在多个部门下时会有多条记录 */
        private String userid;
        /** 用户所属部门 */
        private Integer department;

        public DeptUser() {
        }

        public String getUserid() {
            return userid;
        }

        public void setUserid(String userid) {
            this.userid = userid;
        }

        public Integer getDepartment() {
            return department;
        }

        public void setDepartment(Integer department) {
            this.department = department;
        }
    }
}
