package cn.net.wanmo.common.weixin.work.inner.server_api.pojo.material;

import cn.net.wanmo.common.restful.body.Res;
import cn.net.wanmo.common.util.StringUtil;
import cn.net.wanmo.common.weixin.work.inner.pojo.WechatRes;
import com.alibaba.fastjson.JSONObject;

public class UploadTemporaryRes extends WechatRes {
    @Override
    public Res parse(JSONObject jsonObject) {
        super.parse(jsonObject);

        if (isSuccess() == false) {
            return this;
        }

        this.mediaType = MediaType.valueOf(jsonObject.getString("type"));
        this.mediaId = jsonObject.getString("media_id");
        this.createdAt = jsonObject.getString("created_at");

        return this;
    }

    /** 媒体文件类型，分别有图片（image）、语音（voice）、视频（video），普通文件(file) */
    private MediaType mediaType;
    /** 媒体文件上传后获取的唯一标识，3天内有效 */
    private String mediaId;
    /** 媒体文件上传时间戳 */
    private String createdAt;

    public UploadTemporaryRes() {
    }

    public MediaType getMediaType() {
        return mediaType;
    }

    public void setMediaType(MediaType mediaType) {
        this.mediaType = mediaType;
    }

    public String getMediaId() {
        return mediaId;
    }

    public void setMediaId(String mediaId) {
        this.mediaId = mediaId;
    }

    public String getCreatedAt() {
        return createdAt;
    }

    public void setCreatedAt(String createdAt) {
        this.createdAt = createdAt;
    }

    public enum MediaType {
        image("image", "图片"),
        voice("voice", "语音"),
        video("video", "视频"),
        file("file", "普通文件");

        private final String value;
        private final String label;

        MediaType(String value, String label) {
            this.value = value;
            this.label = label;
        }

        public String getValue() {
            return value;
        }

        public String getLabel() {
            return label;
        }

        public static MediaType get(String value) {
            if (StringUtil.equals(image.getValue(), value)) {
                return image;
            }
            if (StringUtil.equals(voice.getValue(), value)) {
                return voice;
            }
            if (StringUtil.equals(video.getValue(), value)) {
                return video;
            }
            if (StringUtil.equals(file.getValue(), value)) {
                return file;
            }

            return null;
        }

    }
}
