package cn.net.wanmo.common.weixin.work.inner.server_api.pojo.token;

import cn.net.wanmo.common.restful.body.BodyType;
import cn.net.wanmo.common.restful.body.Res;
import cn.net.wanmo.common.util.DateUtil;
import cn.net.wanmo.common.weixin.work.inner.pojo.WechatRes;
import com.alibaba.fastjson.JSONObject;

/**
 * 访问令牌
 * <pre>
 * access_token的有效期通过返回的expires_in来传达，正常情况下为7200秒（2小时），有效期内重复获取返回相同结果，过期后获取会返回新的access_token。
 * 由于企业微信每个应用的access_token是彼此独立的，所以进行缓存时需要区分应用来进行存储。
 * access_token至少保留512字节的存储空间。
 * 企业微信可能会出于运营需要，提前使access_token失效，开发者应实现access_token失效时重新获取的逻辑。
 * </prd>
 *
 * 令牌获取机制
 * <pre>
 *     获取令牌的任务线程中，
 * </pre>
 */
public class AccessTokenRes extends WechatRes {
    @Override
    public Res parse(JSONObject jsonObject) {
        super.parse(jsonObject);

        if (isSuccess() == false) {
            return this;
        }

        this.token = jsonObject.getString("access_token");
        this.expiresIn = jsonObject.getInteger("expires_in");
        this.resTime = DateUtil.nowLong();

        return this;
    }


    /** 获取到的凭证，最长为512字节 */
    private String token;
    /** 凭证的有效时间（秒） */
    private Integer expiresIn;

    public AccessTokenRes() {
    }


    public String getToken() {
        return token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public Integer getExpiresIn() {
        return expiresIn;
    }

    public void setExpiresIn(Integer expiresIn) {
        this.expiresIn = expiresIn;
    }

}
