/*
 * Decompiled with CFR 0.152.
 */
package cn.net.wanmo.common.weixin.work.inner.server_api.storage;

import cn.net.wanmo.common.result.InterfaceResult;
import cn.net.wanmo.common.util.DateUtil;
import cn.net.wanmo.common.util.Threads;
import cn.net.wanmo.common.weixin.work.inner.pojo.Corp;
import cn.net.wanmo.common.weixin.work.inner.pojo.log.TokenLog;
import cn.net.wanmo.common.weixin.work.inner.pojo.token.AccessToken;
import cn.net.wanmo.common.weixin.work.inner.server_api.pojo.token.AccessTokenReq;
import cn.net.wanmo.common.weixin.work.inner.server_api.pojo.token.AccessTokenRes;
import cn.net.wanmo.common.weixin.work.inner.server_api.util.WorkInnerUtil;
import cn.net.wanmo.common.weixin.work.pojo.Token;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccessTokenForCorp {
    private static Logger logger = LoggerFactory.getLogger(AccessTokenForCorp.class);
    private static Map<String, Corp> corpMap = new HashMap<String, Corp>();

    public static <AddressBookToken extends AccessToken> void putCorp(String corpId, Corp<AddressBookToken> corp) {
        ((Token)corp.getAddressBookToken()).storeToken();
        corpMap.put(corpId, corp);
    }

    public static <AddressBookToken extends AccessToken> Corp<AddressBookToken> getCorp(String corpId) {
        return corpMap.getOrDefault(corpId, new Corp());
    }

    public static InterfaceResult<AccessTokenRes> initTokenForAddressBook(Corp corp) {
        String corpId = corp.getCorpId();
        String addressBookSecret = corp.getAddressBookSecret();
        return AccessTokenForCorp.initTokenForAddressBook(corpId, addressBookSecret, null);
    }

    public static <AddressBookToken extends AccessToken> InterfaceResult<AccessTokenRes> initTokenForAddressBook(Corp corp, AddressBookToken addressBookToken) {
        String corpId = corp.getCorpId();
        String addressBookSecret = corp.getAddressBookSecret();
        return AccessTokenForCorp.initTokenForAddressBook(corpId, addressBookSecret, addressBookToken);
    }

    public static InterfaceResult<AccessTokenRes> initTokenForAddressBook(String corpId, String addressBookSecret) {
        return AccessTokenForCorp.initTokenForAddressBook(corpId, addressBookSecret, null);
    }

    public static <AddressBookToken extends AccessToken> InterfaceResult<AccessTokenRes> initTokenForAddressBook(String corpId, String addressBookSecret, AddressBookToken addressBookToken) {
        Corp<AccessToken> corp;
        AccessTokenReq req = AccessTokenReq.build(corpId, addressBookSecret);
        InterfaceResult<AccessTokenRes> result = WorkInnerUtil.getAccessToken(req);
        AccessToken accessToken = new AccessToken();
        accessToken.setCorpId(corpId);
        accessToken.setTokenType(AccessToken.TokenType.access_address_book);
        accessToken.setCode(result.getCode());
        accessToken.setMsg(result.getMsg());
        accessToken.setResTime(DateUtil.nowLong());
        if (result.isSuccess()) {
            AccessTokenRes data = (AccessTokenRes)((Object)result.getData());
            accessToken.setValue(data.getToken());
            accessToken.setExpiresIn(data.getExpiresIn());
            accessToken.setResTime(data.getResTime());
        }
        if (Objects.isNull(addressBookToken)) {
            corp = AccessTokenForCorp.getCorp(corpId);
            corp.setAddressBookToken(accessToken);
            AccessTokenForCorp.putCorp(corpId, corp);
            logger.debug("\u4f01\u4e1a\u5fae\u4fe1ID: {}, \u6267\u884c\u9ed8\u8ba4\u5b58\u50a8\u901a\u8baf\u5f55\u4ee4\u724c\u5b8c\u6210 ...", (Object)corpId);
        } else {
            addressBookToken.setCorpId(corpId);
            addressBookToken.setTokenType(accessToken.getTokenType());
            addressBookToken.setCode(accessToken.getCode());
            addressBookToken.setMsg(accessToken.getMsg());
            addressBookToken.setValue(accessToken.getValue());
            addressBookToken.setExpiresIn(accessToken.getExpiresIn());
            addressBookToken.setResTime(accessToken.getResTime());
            corp = AccessTokenForCorp.getCorp(corpId);
            corp.setAddressBookToken(addressBookToken);
            AccessTokenForCorp.putCorp(corpId, corp);
            logger.debug("\u4f01\u4e1a\u5fae\u4fe1ID: {}, \u6267\u884c\u81ea\u5b9a\u4e49\u5b58\u50a8\u901a\u8baf\u5f55\u4ee4\u724c\u5b8c\u6210 ...", (Object)corpId);
        }
        TokenLog.put(corpId, null, accessToken.getTokenType().getLabel(), accessToken, TokenLog.addressBookTokenMap);
        return result;
    }

    public static void runThreadInitTokenForAddressBook(Corp corp) {
        String corpId = corp.getCorpId();
        String addressBookSecret = corp.getAddressBookSecret();
        AccessTokenForCorp.runThreadInitTokenForAddressBook(corpId, addressBookSecret, null, null, null);
    }

    public static <AddressBookToken extends AccessToken> void runThreadInitTokenForAddressBook(Corp corp, AddressBookToken addressBookToken) {
        String corpId = corp.getCorpId();
        String addressBookSecret = corp.getAddressBookSecret();
        AccessTokenForCorp.runThreadInitTokenForAddressBook(corpId, addressBookSecret, null, null, addressBookToken);
    }

    public static <AddressBookToken extends AccessToken> void runThreadInitTokenForAddressBook(Corp corp, Integer residueSecond, Integer waitSecond) {
        String corpId = corp.getCorpId();
        String addressBookSecret = corp.getAddressBookSecret();
        AccessTokenForCorp.runThreadInitTokenForAddressBook(corpId, addressBookSecret, residueSecond, waitSecond, null);
    }

    public static <AddressBookToken extends AccessToken> void runThreadInitTokenForAddressBook(Corp corp, AddressBookToken addressBookToken, Integer residueSecond, Integer waitSecond) {
        String corpId = corp.getCorpId();
        String addressBookSecret = corp.getAddressBookSecret();
        AccessTokenForCorp.runThreadInitTokenForAddressBook(corpId, addressBookSecret, residueSecond, waitSecond, addressBookToken);
    }

    public static void runThreadInitTokenForAddressBook(String corpId, String addressBookSecret) {
        AccessTokenForCorp.runThreadInitTokenForAddressBook(corpId, addressBookSecret, null, null, null);
    }

    public static <AddressBookToken extends AccessToken> void runThreadInitTokenForAddressBook(String corpId, String addressBookSecret, AddressBookToken addressBookToken) {
        AccessTokenForCorp.runThreadInitTokenForAddressBook(corpId, addressBookSecret, null, null, addressBookToken);
    }

    public static void runThreadInitTokenForAddressBook(String corpId, String addressBookSecret, Integer residueSecond, Integer waitSecond) {
        AccessTokenForCorp.runThreadInitTokenForAddressBook(corpId, addressBookSecret, residueSecond, waitSecond, null);
    }

    public static <AddressBookToken extends AccessToken> void runThreadInitTokenForAddressBook(final String corpId, final String addressBookSecret, final Integer residueSecond, final Integer waitSecond, final AddressBookToken addressBookToken) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                while (true) {
                    try {
                        while (true) {
                            InterfaceResult<AccessTokenRes> result;
                            if ((result = AccessTokenForCorp.initTokenForAddressBook(corpId, addressBookSecret, addressBookToken)).isSuccess()) {
                                String token = ((AccessTokenRes)((Object)result.getData())).getToken();
                                Integer expiresIn = ((AccessTokenRes)((Object)result.getData())).getExpiresIn();
                                logger.debug("\u4f01\u4e1a\u5fae\u4fe1ID: {}, \u5b9a\u65f6\u4efb\u52a1\u83b7\u53d6 \u901a\u8baf\u5f55\u4ee4\u724c \u6210\u529f\uff0cexpiresIn = {}\uff0c token = {}", new Object[]{corpId, expiresIn, token});
                                Threads.sleep((long)((expiresIn - (residueSecond == null ? 30 : residueSecond)) * 1000));
                                continue;
                            }
                            logger.error("\u4f01\u4e1a\u5fae\u4fe1ID: {}, \u5b9a\u65f6\u4efb\u52a1\u83b7\u53d6 \u901a\u8baf\u5f55\u4ee4\u724c \u5931\u8d25, errCode:{} errMsg:{}", new Object[]{corpId, result.getCode(), result.getMsg()});
                            Threads.sleep((long)((waitSecond == null ? 60 : waitSecond) * 1000));
                        }
                    }
                    catch (Exception e) {
                        logger.error("\u4f01\u4e1a\u5fae\u4fe1ID: " + corpId + ", \u5b9a\u65f6\u4efb\u52a1\u83b7\u53d6 \u901a\u8baf\u5f55\u4ee4\u724c \u5f02\u5e38", (Throwable)e);
                        Threads.sleep((long)((waitSecond == null ? 60 : waitSecond) * 1000));
                        continue;
                    }
                    break;
                }
            }
        }).start();
    }
}

