/*
 * Decompiled with CFR 0.152.
 */
package cn.net.wanmo.common.weixin.work.inner.server_api.util.address_book;

import cn.net.wanmo.common.restful.SendUtil;
import cn.net.wanmo.common.restful.body.Req;
import cn.net.wanmo.common.restful.body.Res;
import cn.net.wanmo.common.result.InterfaceResult;
import cn.net.wanmo.common.util.StringUtil;
import cn.net.wanmo.common.weixin.work.inner.pojo.Corp;
import cn.net.wanmo.common.weixin.work.inner.pojo.token.AccessToken;
import cn.net.wanmo.common.weixin.work.inner.server_api.pojo.address_book.DeptCreateReq;
import cn.net.wanmo.common.weixin.work.inner.server_api.pojo.address_book.DeptCreateRes;
import cn.net.wanmo.common.weixin.work.inner.server_api.pojo.address_book.DeptSimpleListReq;
import cn.net.wanmo.common.weixin.work.inner.server_api.pojo.address_book.DeptSimpleListRes;
import cn.net.wanmo.common.weixin.work.inner.server_api.util.WorkInnerUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DepartmentUtil {
    private static Logger logger = LoggerFactory.getLogger(DepartmentUtil.class);

    public static <AddressBookToken extends AccessToken> InterfaceResult<DeptCreateRes> createDept(Corp<AddressBookToken> corp, DeptCreateReq req) {
        String logPrevDesc = corp.getLogPrevDesc();
        String token = corp.takeTokenForAddressBook();
        return DepartmentUtil.createDept(logPrevDesc, token, req);
    }

    public static <AddressBookToken extends AccessToken> InterfaceResult<DeptCreateRes> createDept(String token, DeptCreateReq req) {
        return DepartmentUtil.createDept(null, token, req);
    }

    public static <AddressBookToken extends AccessToken> InterfaceResult<DeptCreateRes> createDept(String logPrevDesc, String token, DeptCreateReq req) {
        String msgPre = WorkInnerUtil.getMsgPre(logPrevDesc, "\u901a\u8baf\u5f55\u7ba1\u7406 \u521b\u5efa\u90e8\u95e8: ");
        req.setBody(req.toJSONString());
        DeptCreateRes res = new DeptCreateRes();
        String url = "https://qyapi.weixin.qq.com/cgi-bin/department/create?access_token=ACCESS_TOKEN";
        url = url.replace("ACCESS_TOKEN", token);
        return SendUtil.sendPostForJson((String)msgPre, (String)url, (Req)req, (Res)res, (Logger)logger, Integer.class);
    }

    public static <AddressBookToken extends AccessToken> void updateDept() {
        String url = "https://qyapi.weixin.qq.com/cgi-bin/department/update?access_token=ACCESS_TOKEN";
    }

    public static <AddressBookToken extends AccessToken> void deleteDept() {
        String url = "https://qyapi.weixin.qq.com/cgi-bin/department/delete?access_token=ACCESS_TOKEN&id=ID";
    }

    public static <AddressBookToken extends AccessToken> InterfaceResult<DeptSimpleListRes> simpleList(Corp<AddressBookToken> corp, DeptSimpleListReq req) {
        String logPrevDesc = corp.getLogPrevDesc();
        String token = corp.takeTokenForAddressBook();
        return DepartmentUtil.simpleList(logPrevDesc, token, req);
    }

    public static <AddressBookToken extends AccessToken> InterfaceResult<DeptSimpleListRes> simpleList(String token, DeptSimpleListReq req) {
        return DepartmentUtil.simpleList(null, token, req);
    }

    public static <AddressBookToken extends AccessToken> InterfaceResult<DeptSimpleListRes> simpleList(String logPrevDesc, String token, DeptSimpleListReq req) {
        String msgPre = WorkInnerUtil.getMsgPre(logPrevDesc, "\u901a\u8baf\u5f55\u7ba1\u7406 \u83b7\u53d6\u5b50\u90e8\u95e8ID\u5217\u8868: ");
        DeptSimpleListRes res = new DeptSimpleListRes();
        String url = "https://qyapi.weixin.qq.com/cgi-bin/department/simplelist?access_token=ACCESS_TOKEN&id=ID";
        url = url.replace("ACCESS_TOKEN", token);
        url = url.replace("ID", StringUtil.isBlank((CharSequence)req.getId()) ? "" : req.getId());
        return SendUtil.sendGet((String)msgPre, (String)url, (Req)req, (Res)res, (Logger)logger, Integer.class);
    }
}

