/*
 * Decompiled with CFR 0.152.
 */
package cn.net.wanmo.common.weixin.work.inner.server_api.util.address_book;

import cn.net.wanmo.common.restful.SendUtil;
import cn.net.wanmo.common.restful.body.Req;
import cn.net.wanmo.common.restful.body.Res;
import cn.net.wanmo.common.result.InterfaceResult;
import cn.net.wanmo.common.util.StringUtil;
import cn.net.wanmo.common.weixin.work.inner.pojo.Corp;
import cn.net.wanmo.common.weixin.work.inner.pojo.token.AccessToken;
import cn.net.wanmo.common.weixin.work.inner.server_api.pojo.address_book.UserAuthSuccReq;
import cn.net.wanmo.common.weixin.work.inner.server_api.pojo.address_book.UserAuthSuccRes;
import cn.net.wanmo.common.weixin.work.inner.server_api.pojo.address_book.UserBatchDeleteReq;
import cn.net.wanmo.common.weixin.work.inner.server_api.pojo.address_book.UserBatchDeleteRes;
import cn.net.wanmo.common.weixin.work.inner.server_api.pojo.address_book.UserConvertToOpenidReq;
import cn.net.wanmo.common.weixin.work.inner.server_api.pojo.address_book.UserConvertToOpenidRes;
import cn.net.wanmo.common.weixin.work.inner.server_api.pojo.address_book.UserConvertToUseridReq;
import cn.net.wanmo.common.weixin.work.inner.server_api.pojo.address_book.UserConvertToUseridRes;
import cn.net.wanmo.common.weixin.work.inner.server_api.pojo.address_book.UserCreateReq;
import cn.net.wanmo.common.weixin.work.inner.server_api.pojo.address_book.UserCreateRes;
import cn.net.wanmo.common.weixin.work.inner.server_api.pojo.address_book.UserDeleteReq;
import cn.net.wanmo.common.weixin.work.inner.server_api.pojo.address_book.UserDeleteRes;
import cn.net.wanmo.common.weixin.work.inner.server_api.pojo.address_book.UserGetIdByEmailReq;
import cn.net.wanmo.common.weixin.work.inner.server_api.pojo.address_book.UserGetIdByEmailRes;
import cn.net.wanmo.common.weixin.work.inner.server_api.pojo.address_book.UserGetIdByMobileReq;
import cn.net.wanmo.common.weixin.work.inner.server_api.pojo.address_book.UserGetIdByMobileRes;
import cn.net.wanmo.common.weixin.work.inner.server_api.pojo.address_book.UserGetReq;
import cn.net.wanmo.common.weixin.work.inner.server_api.pojo.address_book.UserGetRes;
import cn.net.wanmo.common.weixin.work.inner.server_api.pojo.address_book.UserListIdReq;
import cn.net.wanmo.common.weixin.work.inner.server_api.pojo.address_book.UserListIdRes;
import cn.net.wanmo.common.weixin.work.inner.server_api.pojo.address_book.UserUpdateReq;
import cn.net.wanmo.common.weixin.work.inner.server_api.pojo.address_book.UserUpdateRes;
import cn.net.wanmo.common.weixin.work.inner.server_api.util.WorkInnerUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserUtil {
    private static Logger logger = LoggerFactory.getLogger(UserUtil.class);

    public static <AddressBookToken extends AccessToken> InterfaceResult<UserCreateRes> createUser(Corp<AddressBookToken> corp, UserCreateReq req) {
        String logPrevDesc = corp.getLogPrevDesc();
        String token = corp.takeTokenForAddressBook();
        return UserUtil.createUser(logPrevDesc, token, req);
    }

    public static InterfaceResult<UserCreateRes> createUser(String logPrevDesc, String token, UserCreateReq req) {
        String msgPre = WorkInnerUtil.getMsgPre(logPrevDesc, "\u901a\u8baf\u5f55\u7ba1\u7406 \u8bfb\u53d6\u6210\u5458: ");
        req.setBody(req.toJSONString());
        UserCreateRes res = new UserCreateRes();
        String url = "https://qyapi.weixin.qq.com/cgi-bin/user/create?access_token=ACCESS_TOKEN";
        url = url.replace("ACCESS_TOKEN", token);
        return SendUtil.sendPostForJson((String)msgPre, (String)url, (Req)req, (Res)res, (Logger)logger, Integer.class);
    }

    @Deprecated
    public static <AddressBookToken extends AccessToken> InterfaceResult<UserGetRes> getUser(Corp<AddressBookToken> corp, UserGetReq req) {
        String logPrevDesc = corp.getLogPrevDesc();
        String token = corp.takeTokenForAddressBook();
        return UserUtil.getUser(logPrevDesc, token, req);
    }

    @Deprecated
    public static InterfaceResult<UserGetRes> getUser(String logPrevDesc, String token, UserGetReq req) {
        String msgPre = WorkInnerUtil.getMsgPre(logPrevDesc, "\u901a\u8baf\u5f55\u7ba1\u7406 \u8bfb\u53d6\u6210\u5458: ");
        req.setBody(req.toJSONString());
        UserGetRes res = new UserGetRes();
        String url = "https://qyapi.weixin.qq.com/cgi-bin/user/get?access_token=ACCESS_TOKEN&userid=USERID";
        url = url.replace("ACCESS_TOKEN", token).replace("USERID", req.getUserId());
        return SendUtil.sendPostForJson((String)msgPre, (String)url, (Req)req, (Res)res, (Logger)logger, Integer.class);
    }

    public static <AddressBookToken extends AccessToken> InterfaceResult<UserUpdateRes> updateUser(Corp<AddressBookToken> corp, UserUpdateReq req) {
        String logPrevDesc = corp.getLogPrevDesc();
        String token = corp.takeTokenForAddressBook();
        return UserUtil.updateUser(logPrevDesc, token, req);
    }

    public static InterfaceResult<UserUpdateRes> updateUser(String logPrevDesc, String token, UserUpdateReq req) {
        String msgPre = WorkInnerUtil.getMsgPre(logPrevDesc, "\u901a\u8baf\u5f55\u7ba1\u7406 \u66f4\u65b0\u6210\u5458: ");
        req.setBody(req.toJSONString());
        UserUpdateRes res = new UserUpdateRes();
        String url = "https://qyapi.weixin.qq.com/cgi-bin/user/update?access_token=ACCESS_TOKEN";
        url = url.replace("ACCESS_TOKEN", token);
        return SendUtil.sendPostForJson((String)msgPre, (String)url, (Req)req, (Res)res, (Logger)logger, Integer.class);
    }

    public static <AddressBookToken extends AccessToken> InterfaceResult<UserDeleteRes> deleteUser(Corp<AddressBookToken> corp, UserDeleteReq req) {
        String logPrevDesc = corp.getLogPrevDesc();
        String token = corp.takeTokenForAddressBook();
        return UserUtil.deleteUser(logPrevDesc, token, req);
    }

    public static InterfaceResult<UserDeleteRes> deleteUser(String logPrevDesc, String token, UserDeleteReq req) {
        String msgPre = WorkInnerUtil.getMsgPre(logPrevDesc, "\u901a\u8baf\u5f55\u7ba1\u7406 \u5220\u9664\u6210\u5458: ");
        UserDeleteRes res = new UserDeleteRes();
        String url = "https://qyapi.weixin.qq.com/cgi-bin/user/delete?access_token=ACCESS_TOKEN&userid=USERID";
        url = url.replace("ACCESS_TOKEN", token);
        url = url.replace("USERID", StringUtil.isBlank((CharSequence)req.getUserid()) ? "" : req.getUserid());
        return SendUtil.sendGet((String)msgPre, (String)url, (Req)req, (Res)res, (Logger)logger, Integer.class);
    }

    public static <AddressBookToken extends AccessToken> InterfaceResult<UserBatchDeleteRes> batchDeleteUser(Corp<AddressBookToken> corp, UserBatchDeleteReq req) {
        String logPrevDesc = corp.getLogPrevDesc();
        String token = corp.takeTokenForAddressBook();
        return UserUtil.batchDeleteUser(logPrevDesc, token, req);
    }

    public static InterfaceResult<UserBatchDeleteRes> batchDeleteUser(String logPrevDesc, String token, UserBatchDeleteReq req) {
        String msgPre = WorkInnerUtil.getMsgPre(logPrevDesc, "\u901a\u8baf\u5f55\u7ba1\u7406 \u6279\u91cf\u5220\u9664\u6210\u5458: ");
        req.setBody(req.toJSONString());
        UserBatchDeleteRes res = new UserBatchDeleteRes();
        String url = "https://qyapi.weixin.qq.com/cgi-bin/user/batchdelete?access_token=ACCESS_TOKEN";
        url = url.replace("ACCESS_TOKEN", token);
        return SendUtil.sendPostForJson((String)msgPre, (String)url, (Req)req, (Res)res, (Logger)logger, Integer.class);
    }

    public static <AddressBookToken extends AccessToken> void simpleListByDeptId() {
        String url = "https://qyapi.weixin.qq.com/cgi-bin/user/simplelist?access_token=ACCESS_TOKEN&department_id=DEPARTMENT_ID";
    }

    public static <AddressBookToken extends AccessToken> void listByDeptId() {
        String url = "https://qyapi.weixin.qq.com/cgi-bin/user/list?access_token=ACCESS_TOKEN&department_id=DEPARTMENT_ID";
    }

    public static <AddressBookToken extends AccessToken> InterfaceResult<UserConvertToOpenidRes> convertToOpenid(Corp<AddressBookToken> corp, UserConvertToOpenidReq req) {
        String logPrevDesc = corp.getLogPrevDesc();
        String token = corp.takeTokenForAddressBook();
        return UserUtil.convertToOpenid(logPrevDesc, token, req);
    }

    public static InterfaceResult<UserConvertToOpenidRes> convertToOpenid(String logPrevDesc, String token, UserConvertToOpenidReq req) {
        String msgPre = WorkInnerUtil.getMsgPre(logPrevDesc, "\u901a\u8baf\u5f55\u7ba1\u7406 userid\u8f6copenid: ");
        req.setBody(req.toJSONString());
        UserConvertToOpenidRes res = new UserConvertToOpenidRes();
        String url = "https://qyapi.weixin.qq.com/cgi-bin/user/convert_to_openid?access_token=ACCESS_TOKEN";
        url = url.replace("ACCESS_TOKEN", token);
        return SendUtil.sendPostForJson((String)msgPre, (String)url, (Req)req, (Res)res, (Logger)logger, Integer.class);
    }

    public static <AddressBookToken extends AccessToken> InterfaceResult<UserConvertToUseridRes> convertToUserid(Corp<AddressBookToken> corp, UserConvertToUseridReq req) {
        String logPrevDesc = corp.getLogPrevDesc();
        String token = corp.takeTokenForAddressBook();
        return UserUtil.convertToUserid(logPrevDesc, token, req);
    }

    public static InterfaceResult<UserConvertToUseridRes> convertToUserid(String logPrevDesc, String token, UserConvertToUseridReq req) {
        String msgPre = WorkInnerUtil.getMsgPre(logPrevDesc, "\u901a\u8baf\u5f55\u7ba1\u7406 openid\u8f6cuserid: ");
        req.setBody(req.toJSONString());
        UserConvertToUseridRes res = new UserConvertToUseridRes();
        String url = "https://qyapi.weixin.qq.com/cgi-bin/user/convert_to_userid?access_token=ACCESS_TOKEN";
        url = url.replace("ACCESS_TOKEN", token);
        return SendUtil.sendPostForJson((String)msgPre, (String)url, (Req)req, (Res)res, (Logger)logger, Integer.class);
    }

    public static <AddressBookToken extends AccessToken> InterfaceResult<UserAuthSuccRes> authSucc(Corp<AddressBookToken> corp, UserAuthSuccReq req) {
        String logPrevDesc = corp.getLogPrevDesc();
        String token = corp.takeTokenForAddressBook();
        return UserUtil.authSucc(logPrevDesc, token, req);
    }

    public static InterfaceResult<UserAuthSuccRes> authSucc(String logPrevDesc, String token, UserAuthSuccReq req) {
        String msgPre = WorkInnerUtil.getMsgPre(logPrevDesc, "\u901a\u8baf\u5f55\u7ba1\u7406 \u767b\u5f55\u4e8c\u6b21\u9a8c\u8bc1: ");
        UserAuthSuccRes res = new UserAuthSuccRes();
        String url = "https://qyapi.weixin.qq.com/cgi-bin/user/authsucc?access_token=ACCESS_TOKEN&userid=USERID";
        url = url.replace("ACCESS_TOKEN", token);
        url = url.replace("USERID", StringUtil.isBlank((CharSequence)req.getUserid()) ? "" : req.getUserid());
        return SendUtil.sendGet((String)msgPre, (String)url, (Req)req, (Res)res, (Logger)logger, Integer.class);
    }

    public static <AddressBookToken extends AccessToken> void batchInvite() {
        String url = "https://qyapi.weixin.qq.com/cgi-bin/batch/invite?access_token=ACCESS_TOKEN";
    }

    public static <AddressBookToken extends AccessToken> void getJoinQrcode() {
        String url = "https://qyapi.weixin.qq.com/cgi-bin/corp/get_join_qrcode?access_token=ACCESS_TOKEN&size_type=SIZE_TYPE";
    }

    public static <AddressBookToken extends AccessToken> InterfaceResult<UserGetIdByMobileRes> getUseridByMobile(Corp<AddressBookToken> corp, UserGetIdByMobileReq req) {
        String logPrevDesc = corp.getLogPrevDesc();
        String token = corp.takeTokenForAddressBook();
        return UserUtil.getUseridByMobile(logPrevDesc, token, req);
    }

    public static InterfaceResult<UserGetIdByMobileRes> getUseridByMobile(String logPrevDesc, String token, UserGetIdByMobileReq req) {
        String msgPre = WorkInnerUtil.getMsgPre(logPrevDesc, "\u901a\u8baf\u5f55\u7ba1\u7406 \u624b\u673a\u53f7\u83b7\u53d6userid: ");
        req.setBody(req.toJSONString());
        UserGetIdByMobileRes res = new UserGetIdByMobileRes();
        String url = "https://qyapi.weixin.qq.com/cgi-bin/user/getuserid?access_token=ACCESS_TOKEN";
        url = url.replace("ACCESS_TOKEN", token);
        return SendUtil.sendPostForJson((String)msgPre, (String)url, (Req)req, (Res)res, (Logger)logger, Integer.class);
    }

    public static <AddressBookToken extends AccessToken> InterfaceResult<UserGetIdByEmailRes> getUseridByEmail(Corp<AddressBookToken> corp, UserGetIdByEmailReq req) {
        String logPrevDesc = corp.getLogPrevDesc();
        String token = corp.takeTokenForAddressBook();
        return UserUtil.getUseridByEmail(logPrevDesc, token, req);
    }

    public static InterfaceResult<UserGetIdByEmailRes> getUseridByEmail(String logPrevDesc, String token, UserGetIdByEmailReq req) {
        String msgPre = WorkInnerUtil.getMsgPre(logPrevDesc, "\u901a\u8baf\u5f55\u7ba1\u7406 \u90ae\u7bb1\u83b7\u53d6userid: ");
        req.setBody(req.toJSONString());
        UserGetIdByEmailRes res = new UserGetIdByEmailRes();
        String url = "https://qyapi.weixin.qq.com/cgi-bin/user/get_userid_by_email?access_token=ACCESS_TOKEN";
        url = url.replace("ACCESS_TOKEN", token);
        return SendUtil.sendPostForJson((String)msgPre, (String)url, (Req)req, (Res)res, (Logger)logger, Integer.class);
    }

    public static <AddressBookToken extends AccessToken> InterfaceResult<UserListIdRes> listId(Corp<AddressBookToken> corp, UserListIdReq req) {
        String logPrevDesc = corp.getLogPrevDesc();
        String token = corp.takeTokenForAddressBook();
        return UserUtil.listId(logPrevDesc, token, req);
    }

    public static InterfaceResult<UserListIdRes> listId(String token, UserListIdReq req) {
        return UserUtil.listId(null, token, req);
    }

    public static InterfaceResult<UserListIdRes> listId(String logPrevDesc, String token, UserListIdReq req) {
        String msgPre = WorkInnerUtil.getMsgPre(logPrevDesc, "\u901a\u8baf\u5f55\u7ba1\u7406 \u83b7\u53d6\u6210\u5458ID\u5217\u8868: ");
        req.setBody(req.toJSONString());
        UserListIdRes res = new UserListIdRes();
        String url = "https://qyapi.weixin.qq.com/cgi-bin/user/list_id?access_token=ACCESS_TOKEN";
        url = url.replace("ACCESS_TOKEN", token);
        return SendUtil.sendPostForJson((String)msgPre, (String)url, (Req)req, (Res)res, (Logger)logger, Integer.class);
    }
}

