/*
 * Decompiled with CFR 0.152.
 */
package cn.net.wanmo.common.weixin.work.inner.server_api.util.message_push;

import cn.net.wanmo.common.restful.SendUtil;
import cn.net.wanmo.common.restful.body.Req;
import cn.net.wanmo.common.restful.body.Res;
import cn.net.wanmo.common.result.InterfaceResult;
import cn.net.wanmo.common.weixin.work.inner.pojo.Agent;
import cn.net.wanmo.common.weixin.work.inner.server_api.pojo.message_push.app.MessageReq;
import cn.net.wanmo.common.weixin.work.inner.server_api.pojo.message_push.app.MessageRes;
import cn.net.wanmo.common.weixin.work.inner.server_api.pojo.message_recall.MessageRecallReq;
import cn.net.wanmo.common.weixin.work.inner.server_api.pojo.message_recall.MessageRecallRes;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageUtil {
    private static Logger logger = LoggerFactory.getLogger(MessageUtil.class);

    public static InterfaceResult<MessageRes> sendMessage(Agent agent, MessageReq req) {
        String logPrevDesc = agent.getLogPrevDesc();
        String token = agent.takeToken();
        return MessageUtil.sendMessage(logPrevDesc, token, req);
    }

    public static InterfaceResult<MessageRes> sendMessage(String token, MessageReq req) {
        return MessageUtil.sendMessage(null, token, req);
    }

    public static InterfaceResult<MessageRes> sendMessage(String logPrevDesc, String token, MessageReq req) {
        String msgPre = (StringUtils.isBlank((CharSequence)logPrevDesc) ? "" : logPrevDesc + ":") + "\u6d88\u606f\u63a8\u9001 \u53d1\u9001\u5e94\u7528\u6d88\u606f: ";
        req.setBody(req.toJSONString());
        MessageRes res = new MessageRes();
        String url = "https://qyapi.weixin.qq.com/cgi-bin/message/send?access_token=ACCESS_TOKEN";
        url = url.replace("ACCESS_TOKEN", token);
        return SendUtil.sendPostForJson((String)msgPre, (String)url, (Req)req, (Res)res, (Logger)logger, Integer.class);
    }

    public static InterfaceResult<MessageRecallRes> recallMessage(Agent agent, MessageRecallReq req) {
        String logPrevDesc = agent.getLogPrevDesc();
        String token = agent.takeToken();
        return MessageUtil.recallMessage(logPrevDesc, token, req);
    }

    public static InterfaceResult<MessageRecallRes> recallMessage(String token, String msgId) {
        return MessageUtil.recallMessage(null, token, msgId);
    }

    public static InterfaceResult<MessageRecallRes> recallMessage(String logPrevDesc, String token, String msgId) {
        MessageRecallReq req = MessageRecallReq.build(msgId);
        return MessageUtil.recallMessage(logPrevDesc, token, req);
    }

    public static InterfaceResult<MessageRecallRes> recallMessage(String token, MessageRecallReq req) {
        return MessageUtil.recallMessage(null, token, req);
    }

    public static InterfaceResult<MessageRecallRes> recallMessage(String logPrevDesc, String token, MessageRecallReq req) {
        String msgPre = (StringUtils.isBlank((CharSequence)logPrevDesc) ? "" : logPrevDesc + ":") + "\u6d88\u606f\u64a4\u56de \u64a4\u56de\u5e94\u7528\u6d88\u606f: ";
        req.setBody(req.toJSONString());
        MessageRecallRes res = new MessageRecallRes();
        String url = "https://qyapi.weixin.qq.com/cgi-bin/message/recall?access_token=ACCESS_TOKEN";
        url = url.replace("ACCESS_TOKEN", token);
        return SendUtil.sendPostForJson((String)msgPre, (String)url, (Req)req, (Res)res, (Logger)logger, Integer.class);
    }
}

